/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.exception.ValidationException;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigrationException;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigratorFactory;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.CrowdPropertiesPersisterImpl;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.CrowdRepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.HibernateRepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.LdapRepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.RepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.UserConfigurationChecker;
import com.atlassian.bamboo.upgrade.tasks.validation.EmbeddedCrowdUpgradeBootstrapValidation;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class AtlassianUserRepositoriesAreValid
extends EmbeddedCrowdUpgradeBootstrapValidation {
    private static final Logger log = Logger.getLogger(AtlassianUserRepositoriesAreValid.class);

    public AtlassianUserRepositoriesAreValid() {
        super("60601", "Validate existing Atlassian User directories for Embedded Crowd migration");
    }

    public void doUpgrade() throws Exception {
        this.doUpgrade(UserConfigurationChecker.getAtlassianUserConfiguration(Paths.get(this.bootstrapManager.getConfigDirectory(), new String[0])));
    }

    @VisibleForTesting
    public void doUpgrade(List<RepositoryConfiguration> atlassianUserConfiguration) throws Exception {
        this.withDatabaseConnection(connection -> {
            if (this.isPostEmbeddedCrowdUpgrade(connection)) {
                log.debug((Object)"Skipping verification since Bamboo is already after Embedded Crowd upgrade");
                return;
            }
            List<String> migrationErrors = this.createConfigurationMigrator(atlassianUserConfiguration).validate();
            if (!migrationErrors.isEmpty()) {
                this.errors.addAll(migrationErrors);
                throw new RuntimeException((Throwable)new ValidationException("Bamboo can't migrate Atlassian User repositories due to validation errors. Please refer to logs for more information."));
            }
        });
    }

    private AtlassianUserMigrator createConfigurationMigrator(List<RepositoryConfiguration> atlassianUserConfiguration) {
        try {
            List<RepositoryConfigurationMigrator> migrators = Arrays.asList(new CrowdRepositoryConfigurationMigrator(null, new CrowdPropertiesPersisterImpl(new File(this.bootstrapManager.getConfigDirectory()))), new LdapRepositoryConfigurationMigrator(null, null), new HibernateRepositoryConfigurationMigrator(null, null, false));
            return new AtlassianUserMigratorFactory(migrators).getMigrator(atlassianUserConfiguration);
        }
        catch (AtlassianUserMigrationException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

