/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.exception.ValidationException;
import com.atlassian.bamboo.upgrade.tasks.validation.EmbeddedCrowdUpgradeBootstrapValidation;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.Lazy;

public class AtlassianUserDataIsValid
extends EmbeddedCrowdUpgradeBootstrapValidation {
    private static final Logger log = Logger.getLogger(AtlassianUserDataIsValid.class);
    @Lazy
    @Inject
    private DbmsBean dbmsBean;
    private static final String DUPLICATED_USERS_SQL = "select    count(*),    lower(NAME) AS ENTITY from    USERS group by    lower(NAME) having    count(*) > 1";

    public AtlassianUserDataIsValid() {
        super("60602", "Validate existing Atlassian User directories for Embedded Crowd migration");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(connection -> {
            if (this.isPostEmbeddedCrowdUpgrade(connection) || !this.containsAtlassianUserTables(connection)) {
                log.debug((Object)"Skipping verification since Bamboo is already after Embedded Crowd upgrade");
                return;
            }
            this.checkForDuplicates(connection);
        });
    }

    private boolean containsAtlassianUserTables(Connection connection) throws SQLException {
        return this.dbmsBean.isTablePresent(connection, "USERS") && this.dbmsBean.isTablePresent(connection, "GROUPS");
    }

    private void checkForDuplicates(Connection connection) throws SQLException {
        Set<String> duplicatedUsers = this.getDuplicatedUsers(connection);
        Set<String> duplicatedGroups = this.getDuplicatedGroups(connection);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!duplicatedUsers.isEmpty()) {
            validationErrors.add(String.format("Bamboo can\u2019t proceed with the upgrade because we\u2002found the following duplicated user names: \n %s", String.join((CharSequence)"\n", duplicatedUsers)));
        }
        if (!duplicatedGroups.isEmpty()) {
            validationErrors.add(String.format("Bamboo can\u2019t proceed with the upgrade because we\u2002found the following duplicated groups: \n %s", String.join((CharSequence)"\n", duplicatedUsers)));
        }
        if (!validationErrors.isEmpty()) {
            this.errors.addAll(validationErrors);
            validationErrors.forEach(arg_0 -> ((Logger)log).error(arg_0));
            throw new RuntimeException(new ValidationException("Bamboo can\u2019t proceed with the upgrade because we\u2019ve found the duplicated user/group names. Please refer to logs to get full list of duplicated entities.\n In your current Bamboo version, group and user names are case sensitive. You\u2019re trying to upgrade to a Bamboo version where group and user names are not case sensitive. To upgrade, make sure that your user and group names are unique. For example: MyUser and myuser are considered the same in the new Bamboo version."));
        }
    }

    @VisibleForTesting
    public Set<String> getDuplicatedUsers(Connection connection) throws SQLException {
        return this.getDuplicatedEntities(connection, DUPLICATED_USERS_SQL);
    }

    @VisibleForTesting
    public Set<String> getDuplicatedGroups(Connection connection) throws SQLException {
        String groups = "select    count(*),    lower(GROUPNAME) AS ENTITY from    " + this.quoteOnMySql("GROUPS") + " group by    lower(GROUPNAME) having    count(*) > 1";
        return this.getDuplicatedEntities(connection, groups);
    }

    private String quoteOnMySql(String tableName) {
        return this.dbmsBean.isMySql() ? this.dbmsBean.quote(tableName) : tableName;
    }

    private Set<String> getDuplicatedEntities(Connection connection, String query) throws SQLException {
        HashSet<String> duplicatedUsers;
        block25: {
            duplicatedUsers = new HashSet<String>();
            try (Statement statement = connection.createStatement();){
                if (!statement.execute(query)) break block25;
                try (ResultSet resultSet = statement.getResultSet();){
                    while (resultSet.next()) {
                        duplicatedUsers.add(resultSet.getString("ENTITY"));
                    }
                }
            }
        }
        return duplicatedUsers;
    }
}

