/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.ResultSet;
import java.sql.Statement;

public class AllMySqlTablesUseInnoDb
extends AbstractBootstrapUpgradeTask {
    private static final String SHOW_TABLE_STATUS = "SHOW TABLE STATUS FROM `%s` WHERE ENGINE != 'InnoDB'";
    private DbmsBean dbmsBean;

    public AllMySqlTablesUseInnoDb() {
        super("51012", "Make sure that MySQL server uses InnoDB engine for tables");
    }

    public void doUpgrade() throws Exception {
        if (this.dbmsBean.getDatabaseType() == DatabaseType.MYSQL) {
            this.withDatabaseConnection(connection -> {
                try (Statement stmt = connection.createStatement();
                     ResultSet dbNameSelect = stmt.executeQuery("SELECT DATABASE()");){
                    dbNameSelect.next();
                    String dbName = dbNameSelect.getString(1);
                    try (ResultSet rs = stmt.executeQuery(String.format(SHOW_TABLE_STATUS, dbName));){
                        if (rs.next()) {
                            this.errors.add("Bamboo DB must use InnoDB table engine.");
                        }
                    }
                }
            });
        }
    }

    public void setDbmsBean(DbmsBean dbmsBean) {
        this.dbmsBean = dbmsBean;
    }
}

