/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_2;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.annotations.VisibleForTesting;
import java.sql.PreparedStatement;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class UpgradeTask70207AddSpecsMissingColumn
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70207AddSpecsMissingColumn.class);
    private final String UPDATE_QUERY = "update VCS_SPECS_STATE set SPECS_NOT_FOUND = ? where SPECS_NOT_FOUND is null";
    @VisibleForTesting
    public static final String TABLE = "VCS_SPECS_STATE";
    @VisibleForTesting
    public static final String COLUMN = "SPECS_NOT_FOUND";
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask70207AddSpecsMissingColumn() {
        super(String.format("Add %s column to %s table", COLUMN, TABLE));
    }

    public void doUpgrade() throws Exception {
        AtomicBoolean tableExists = new AtomicBoolean(true);
        this.withDatabaseConnection(connection -> {
            if (!this.dbmsBean.isTablePresent(connection, TABLE)) {
                log.info((Object)String.format("Table %s doesn't exist. Skipping %s column update", TABLE, COLUMN));
                tableExists.set(false);
                return;
            }
            if (!this.dbmsBean.isColumnPresent(connection, TABLE, COLUMN)) {
                log.info((Object)String.format("Adding column %s to %s", COLUMN, TABLE));
                this.dbmsBean.addColumn(connection, TABLE, COLUMN, 16, null);
            } else {
                log.info((Object)String.format("Column %s already exits in %s", COLUMN, TABLE));
            }
            try (PreparedStatement statement = connection.prepareStatement("update VCS_SPECS_STATE set SPECS_NOT_FOUND = ? where SPECS_NOT_FOUND is null");){
                statement.setBoolean(1, false);
                int updatedRows = statement.executeUpdate();
                log.info((Object)String.format("Update SPECS_NOT_FOUND in %d rows", updatedRows));
            }
        });
        if (tableExists.get()) {
            this.withDatabaseConnection(connection -> this.dbmsBean.changeColumnToNotNull(connection, TABLE, COLUMN));
        }
    }
}

