/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_2;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.deployments.projects.persistence.DeploymentProjectDao;
import com.atlassian.bamboo.deployments.projects.persistence.items.MutableBambooArtifactDeploymentProjectItem;
import com.atlassian.bamboo.deployments.projects.persistence.items.MutableDeploymentProjectItem;
import com.atlassian.bamboo.persistence.BambooConnectionTemplate;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.upgrade.utils.DatabaseUpgradePaginator;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask70205FixDeploymentArtifacts
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70205FixDeploymentArtifacts.class);
    @Inject
    private DeploymentProjectDao deploymentProjectDao;
    @Inject
    private BambooConnectionTemplate bambooConnectionTemplate;
    @Inject
    private ArtifactDefinitionManager artifactDefinitionManager;
    @Inject
    private PlanManager planManager;
    @Autowired
    private DatabaseUpgradePaginator upgradePaginator;

    public UpgradeTask70205FixDeploymentArtifacts() {
        super("Fix artifact references in deployment projects");
    }

    public void doUpgrade() throws Exception {
        this.upgradePaginator.forEach((arg_0, arg_1) -> ((DeploymentProjectDao)this.deploymentProjectDao).getAllDeploymentProjects(arg_0, arg_1), deploymentProject -> {
            if (deploymentProject.getPlanKey() == null) {
                return;
            }
            Chain relatedChain = (Chain)this.planManager.getPlanByKeyIfOfType(deploymentProject.getPlanKey(), Chain.class);
            if (relatedChain == null) {
                return;
            }
            List relatedSharedArtifacts = this.artifactDefinitionManager.findSharedArtifactsByChain((ImmutableChain)relatedChain);
            List projectItems = this.deploymentProjectDao.getProjectItems(deploymentProject.getId());
            HashSet artifactsWithProjectItems = new HashSet();
            projectItems.stream().filter(MutableBambooArtifactDeploymentProjectItem.class::isInstance).map(MutableBambooArtifactDeploymentProjectItem.class::cast).forEach(ai -> {
                if (relatedSharedArtifacts.stream().noneMatch(ad -> ad.getId() == ai.getArtifactDefinition().getId())) {
                    this.deploymentProjectDao.delete((MutableDeploymentProjectItem)ai);
                } else {
                    artifactsWithProjectItems.add(ai.getArtifactDefinition().getId());
                }
            });
            relatedSharedArtifacts.forEach(sa -> {
                if (!artifactsWithProjectItems.contains(sa.getId())) {
                    MutableBambooArtifactDeploymentProjectItem item = new MutableBambooArtifactDeploymentProjectItem();
                    item.setName(sa.getName());
                    item.setArtifactDefinition(sa);
                    item.setDeploymentProject(deploymentProject);
                    this.deploymentProjectDao.save((MutableDeploymentProjectItem)item);
                }
            });
        });
    }
}

