/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_2;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask70204ConvertVariableValueToLargeText
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70204ConvertVariableValueToLargeText.class);
    private final String[] tableNames = new String[]{"VARIABLE_CONTEXT", "STAGE_VARIABLE_CONTEXT", "VARIABLE_BASELINE_ITEM", "VARIABLE_SUBSTITUTION"};
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask70204ConvertVariableValueToLargeText() {
        super("Converting variable value type to large text");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(c -> {
            for (String tableName : this.tableNames) {
                log.info((Object)("Converting " + tableName));
                DbmsBean.ColumnDefinition cd = (DbmsBean.ColumnDefinition)Iterables.getFirst((Iterable)this.dbmsBean.getColumns(c, tableName, "VARIABLE_VALUE"), null);
                if (cd == null || cd.getDataTypeName().equalsIgnoreCase(this.dbmsBean.getLargeTextTypeName())) continue;
                this.dbmsBean.migrateColumnType(c, tableName, "VARIABLE_VALUE", 123450000, null);
            }
        });
    }
}

