/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_2;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask70203RemoveUniqueConstraintInCredentials
extends AbstractBootstrapUpgradeTask {
    private static final String CREDENTIALS_TABLE_NAME = "CREDENTIALS";
    private static final String NAME_COLUMN = "NAME";
    private static final Logger log = Logger.getLogger(UpgradeTask70203RemoveUniqueConstraintInCredentials.class);
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask70203RemoveUniqueConstraintInCredentials() {
        super("Remove constraint on name column in CREDENTIALS table");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(c -> this.dbmsBean.getConstraints(c, CREDENTIALS_TABLE_NAME, NAME_COLUMN).stream().filter(constraint -> constraint.getColumns().stream().allMatch(col -> NAME_COLUMN.equalsIgnoreCase((String)col))).forEach(cd -> {
            try {
                this.dbmsBean.dropConstraint(c, CREDENTIALS_TABLE_NAME, cd.getName());
                log.info((Object)String.format("Constraint %s has been deleted", cd.getName()));
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }));
    }
}

