/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_2;

import com.atlassian.bamboo.build.BuildDefinitionXml;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskConditionConfigImpl;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.upgrade.tasks.AbstractTaskConfigurationUpgradeTask;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask70202MigrateUsernameCondition
extends AbstractTaskConfigurationUpgradeTask {
    private static final String USER_CONDITIONS_KEY = "com.atlassian.bamboo.plugins.bamboo-conditional-tasks:userCondition";
    private static final String USER_CONDITION_USER_KEY = "username";
    private static final String VARIABLE_CONDITIONS_KEY = "com.atlassian.bamboo.plugins.bamboo-conditional-tasks:variableCondition";
    private static final String KEY_VARIABLE = "variable";
    private static final String VARIABLE_VALUE = "ManualBuildTriggerReason.userName";
    private static final String KEY_OPERATION = "operation";
    private static final String OPERATION_VALUE = "equals";
    private static final String KEY_VALUE = "value";

    public UpgradeTask70202MigrateUsernameCondition() {
        super("Migrate Username condition to Variable condition");
    }

    @Override
    protected boolean updateTaskDefinition(TaskDefinition taskDefinition) {
        ArrayList<Object> newTaskConditions = new ArrayList<Object>();
        boolean result = false;
        for (TaskConditionConfig condition : taskDefinition.getConditions()) {
            if (USER_CONDITIONS_KEY.equalsIgnoreCase(condition.getConditionPluginKey())) {
                HashMap<String, String> settings = new HashMap<String, String>();
                settings.put(KEY_VARIABLE, VARIABLE_VALUE);
                String username = (String)condition.getConfiguration().get(USER_CONDITION_USER_KEY);
                if (StringUtils.isEmpty((String)username)) {
                    settings.put(KEY_OPERATION, "exists");
                } else {
                    settings.put(KEY_OPERATION, OPERATION_VALUE);
                    settings.put(KEY_VALUE, username);
                }
                TaskConditionConfigImpl variableCondition = new TaskConditionConfigImpl(VARIABLE_CONDITIONS_KEY, settings);
                newTaskConditions.add(variableCondition);
                result = true;
                continue;
            }
            newTaskConditions.add(condition);
        }
        if (result) {
            taskDefinition.setConditions(newTaskConditions);
        }
        return result;
    }

    @Override
    protected boolean jobCanBeSkipped(@NotNull BuildDefinitionXml buildDefinitionXml) {
        return !StringUtils.defaultString((Object)buildDefinitionXml.getXmlData()).contains(USER_CONDITIONS_KEY);
    }

    @Override
    protected boolean environmentCanBeSkipped(BuildConfiguration buildConfiguration) {
        return !buildConfiguration.asXml().contains(USER_CONDITIONS_KEY);
    }
}

