/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_2;

import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class UpgradeTask70201SetRemoteSharedCapabilitiesSources
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70201SetRemoteSharedCapabilitiesSources.class);
    @Inject
    private CapabilitySetManager capabilitySetManager;

    protected UpgradeTask70201SetRemoteSharedCapabilitiesSources() {
        super("Set remote shared capabilities' sources");
    }

    public void doUpgrade() throws Exception {
        CapabilitySet sharedRemoteCapabilitySet = this.capabilitySetManager.getSharedRemoteCapabilitySet();
        if (sharedRemoteCapabilitySet == null) {
            log.info((Object)"Shared remote capabilities set is not present. Skipping capabilities' sources update");
            return;
        }
        for (Capability capability : sharedRemoteCapabilitySet.getCapabilities()) {
            capability.setCapabilitySource(CapabilitySource.SHARED);
            log.debug((Object)String.format("Updating %s source to SHARED", capability));
        }
        this.capabilitySetManager.saveCapabilitySet(sharedRemoteCapabilitySet);
    }
}

