/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_1;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.upgrade.UpgradeException;
import java.io.File;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class UpgradeTask70111DeleteIndexDirectory
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70111DeleteIndexDirectory.class);

    public UpgradeTask70111DeleteIndexDirectory() {
        super("Delete index directory");
    }

    public void doUpgrade() throws Exception {
        File indexDirectory = this.bootstrapManager.getIndexDirectory();
        if (indexDirectory == null) {
            throw new UpgradeException("bootstrapManager.getIndexDirectory() returned null value");
        }
        log.info((Object)String.format("Dropping your current indexes in %s, in case of rollback please reindex your instance.", indexDirectory));
        BambooPathUtils.deleteDirectory((Path)indexDirectory.toPath());
        if (!indexDirectory.mkdirs()) {
            throw new UpgradeException(String.format("Unable to create directory %s, please try creating it manually and restart the instance.", indexDirectory));
        }
    }
}

