/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_1;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.BambooThrowables;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class UpgradeTask70106RemoveOldRssCache
extends AbstractUpgradeTask {
    @Inject
    private BuildDirectoryManager buildDirectoryManager;

    protected UpgradeTask70106RemoveOldRssCache() {
        super("Remove old RSS execution cache");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doUpgrade() throws Exception {
        Path serverSideWorkingDir = this.buildDirectoryManager.getServerSideTaskWorkingDirectory(BuildDirectoryManager.ServerSideTaskType.REPOSITORY_STORED_SPECS);
        if (!Files.exists(serverSideWorkingDir, new LinkOption[0])) return;
        Pattern pattern = Pattern.compile("^repository-\\d+$");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(serverSideWorkingDir, file -> pattern.matcher(file.getFileName().toString()).matches());){
            for (Path internalYamlsDir : stream) {
                try {
                    BambooPathUtils.forceDelete((Path)internalYamlsDir);
                }
                catch (IOException e) {
                    throw BambooThrowables.propagate((Throwable)e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw BambooThrowables.propagate((Throwable)e);
        }
    }
}

