/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_1;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooConnectionTemplate;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineImpl;
import com.google.common.collect.Iterables;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask70105RemovePasswordVariablesFromBaselines
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70105RemovePasswordVariablesFromBaselines.class);
    @Inject
    private DbmsBean dbmsBean;
    @Inject
    private VariableContextBaselineDao variableContextBaselineDao;
    @Inject
    private BambooConnectionTemplate bambooConnectionTemplate;
    @Inject
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;

    public UpgradeTask70105RemovePasswordVariablesFromBaselines() {
        super("Remove password variables from baselines");
    }

    public void doUpgrade() throws Exception {
        int batchSize = 200;
        ArrayList variableContextBaselinesId = new ArrayList();
        this.bambooConnectionTemplate.execute(c -> {
            try (Statement s = c.createStatement();
                 ResultSet rs = s.executeQuery("select distinct(VARIABLE_CONTEXT_BASELINE_ID) from VARIABLE_BASELINE_ITEM where " + this.getPredicateForSecretFields());){
                while (rs.next()) {
                    variableContextBaselinesId.add(rs.getLong(1));
                }
            }
        });
        AtomicInteger counter = new AtomicInteger();
        Iterables.partition(variableContextBaselinesId, (int)200).forEach(variableContextBaselinesIdPart -> {
            log.info((Object)("Processed " + counter.getAndIncrement() * 200 + " baselines out of " + variableContextBaselinesId.size()));
            this.bambooTransactionHibernateTemplate.execute(session -> {
                variableContextBaselinesIdPart.forEach(id -> {
                    VariableContextBaselineImpl variableContextBaseline = (VariableContextBaselineImpl)this.variableContextBaselineDao.getVariableContextBaseline(id.longValue());
                    variableContextBaseline.removePasswordVariables();
                    this.variableContextBaselineDao.save((BambooObject)variableContextBaseline);
                });
                return null;
            });
        });
    }

    @NotNull
    private String getPredicateForSecretFields() {
        String lowerCaseVariableKeyColumn = this.dbmsBean.toLowerCase("VARIABLE_KEY");
        return String.format("(%s)", PasswordMaskingUtils.PASSWORD_FIELD_NAMES.stream().map(key -> "(" + lowerCaseVariableKeyColumn + " like '%" + key.toLowerCase(Locale.US) + "%')").collect(Collectors.joining(" or ")));
    }
}

