/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_0;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.thoughtworks.xstream.XStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask70020FixCapabilityConfigurationTask
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70020FixCapabilityConfigurationTask.class);
    static final String OLD_FORMAT_STATEMENT = "org.apache.commons.configuration.XMLConfiguration_-XMLNode";
    private static final String SEARCH_QUERY = "select BANDANA_KEY, SERIALIZED_DATA from BANDANA where BANDANA_KEY like '%DefaultCapabilityConfigurationManager%' and SERIALIZED_DATA like '<com.atlassian.bamboo.ww2.actions.build.admin.create.CustomizedXMLConfiguration>%' and SERIALIZED_DATA like '%org.apache.commons.configuration.XMLConfiguration_-XMLNode%'";
    static final String LOG_NODE_BEGIN = "<log class=\"org.apache.commons.logging.LogFactory$Log4jLog\">";
    static final String LOG_NODE_END = "</log>";
    static final String NEW_LOG_NODE = "<log class=\"org.apache.commons.logging.LogAdapter$Slf4jLocationAwareLog\"><name>org.apache.commons.configuration.XMLConfiguration$XMLFileConfigurationDelegate</name></log>";
    @Inject
    private BandanaManager bandanaManager;

    public UpgradeTask70020FixCapabilityConfigurationTask() {
        super("Upgrades settings for Mvn Server Capability when repository isolation enabled - BAM-20960");
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws HibernateException, SQLException {
        ArrayList<Pair> rowsToUpdate = new ArrayList<Pair>();
        try (Statement statement = connection.createStatement();){
            ResultSet data = statement.executeQuery(SEARCH_QUERY);
            while (data.next()) {
                String bandanaKey = data.getString(1);
                String serializedData = data.getString(2);
                XMLConfiguration configuration = this.convert(serializedData);
                if (configuration == null) continue;
                rowsToUpdate.add(Pair.make((Object)bandanaKey, (Object)configuration));
            }
        }
        for (Pair row : rowsToUpdate) {
            String bandanaValue = ConfigUtils.asXmlString((XMLConfiguration)((XMLConfiguration)row.second));
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, (String)row.first, (Object)bandanaValue);
            log.info((Object)("BANDANA value fixed for key = " + (String)row.first));
        }
    }

    private XMLConfiguration convert(String serializedData) {
        int endIndex;
        if (!serializedData.contains(OLD_FORMAT_STATEMENT)) {
            return null;
        }
        int beginIndex = serializedData.indexOf(LOG_NODE_BEGIN);
        if (beginIndex > 0 && (endIndex = serializedData.indexOf(LOG_NODE_END, beginIndex + 1)) > 0 && beginIndex < endIndex && (endIndex += LOG_NODE_END.length()) < serializedData.length()) {
            serializedData = serializedData.substring(0, beginIndex) + NEW_LOG_NODE + serializedData.substring(endIndex);
        }
        XStream xstream = new XStream();
        Object object = xstream.fromXML(serializedData);
        XMLConfiguration configuration = (XMLConfiguration)object;
        return configuration;
    }
}

