/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_0;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask70013DisableSpecsOnExistingPlanBranches
extends AbstractUpgradeTask {
    @Inject
    private PlanManager planManager;
    @Inject
    private VcsRepositoryManager vcsRepositoryManager;
    @Inject
    private ChainBranchManager chainBranchManager;

    public UpgradeTask70013DisableSpecsOnExistingPlanBranches() {
        super("Disable specs processing on plan branches existing before upgrade to 7.0");
    }

    private boolean canCreateDivergentBranchesForChain(@NotNull Chain chain) {
        PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        return defaultRepositoryDefinition != null && defaultRepositoryDefinition.isRootVcsLinked() && chain.getVcsBambooSpecsSource() != null && chain.getVcsBambooSpecsSource().getVcsLocationBambooSpecsState().getVcsLocationId() == defaultRepositoryDefinition.getRootVcsRepositoryId() && this.vcsRepositoryManager.supportsDivergentBranches(defaultRepositoryDefinition.getPluginKey());
    }

    public void doUpgrade() throws Exception {
        if (!SystemProperty.SPECS_FOR_BRANCHES_ENABLED.getTypedValue()) {
            return;
        }
        for (TopLevelPlan chain : this.planManager.getAllPlans(TopLevelPlan.class)) {
            if (!this.canCreateDivergentBranchesForChain((Chain)chain)) continue;
            for (ChainBranch chainBranch : this.chainBranchManager.getBranchesForChain((ImmutableChain)chain)) {
                if (chainBranch.isDivergent()) continue;
                BuildDefinitionForBuild buildDefinition = chainBranch.getBuildDefinitionXml();
                BuildConfiguration buildConfiguration = new BuildConfiguration(buildDefinition.getXmlData());
                buildConfiguration.setProperty("branchConfiguration.specs.ignore", (Object)true);
                buildDefinition.setXmlData(buildConfiguration.asXml());
                this.planManager.savePlan((Plan)chainBranch);
            }
        }
    }
}

