/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_0;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class UpgradeTask70003ChangeECDirectoryAttributeColumnType
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70003ChangeECDirectoryAttributeColumnType.class);
    private static final String CWD_DIRECTORY_ATTRIBUTE_TABLE_NAME = "CWD_DIRECTORY_ATTRIBUTE";
    private static final String ATTRIBUTE_VALUE_COLUMN_NAME = "ATTRIBUTE_VALUE";
    private static final List<Pair<String, String>> COLUMNS = Arrays.asList(Pair.make((Object)"CWD_DIRECTORY_ATTRIBUTE", (Object)"ATTRIBUTE_VALUE"), Pair.make((Object)"CWD_APPLICATION_ATTRIBUTE", (Object)"ATTRIBUTE_VALUE"), Pair.make((Object)"CWD_PROPERTY", (Object)"PROPERTY_VALUE"));
    private static final String REMOVE_EMPTY_VALUES = "delete from CWD_DIRECTORY_ATTRIBUTE where ATTRIBUTE_VALUE is NULL or ATTRIBUTE_VALUE LIKE ''";
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask70003ChangeECDirectoryAttributeColumnType() {
        super("Update CWD_DIRECTORY_ATTRIBUTE column type");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(c -> {
            if (this.dbmsBean.isTablePresent(c, CWD_DIRECTORY_ATTRIBUTE_TABLE_NAME)) {
                try (PreparedStatement statement = c.prepareStatement(REMOVE_EMPTY_VALUES);){
                    int i = statement.executeUpdate();
                    log.info((Object)("Removed " + i + " records from " + CWD_DIRECTORY_ATTRIBUTE_TABLE_NAME + " with empty attributes"));
                }
            }
        });
        for (Pair<String, String> pair : COLUMNS) {
            String tableName = (String)pair.getFirst();
            String columnName = (String)pair.getSecond();
            this.withDatabaseConnection(c -> {
                if (this.dbmsBean.isTablePresent(c, tableName)) {
                    log.info((Object)("Converting " + tableName + "." + columnName + " to clob"));
                    this.dbmsBean.migrateColumnType(c, tableName, columnName, 123450000, null);
                }
            });
        }
    }
}

