/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v7_0;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.manager.PluginEnabledState;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.thoughtworks.xstream.XStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class UpgradeTask70001UpgradePluginStateStore
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask70001UpgradePluginStateStore.class);

    public UpgradeTask70001UpgradePluginStateStore() {
        super("Update format of plugin state store.");
    }

    public void doUpgrade() throws Exception {
        String[] pluginStoreXml = new String[1];
        this.withDatabaseConnection(connection -> {
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery("select SERIALIZED_DATA from BANDANA where BANDANA_KEY = 'bamboo.plugin.state'");){
                if (rs.next()) {
                    pluginStoreXml[0] = rs.getString(1);
                    log.debug((Object)String.format("Current plugin store: [%s]", pluginStoreXml[0]));
                }
                if (rs.next()) {
                    throw new RuntimeException("Duplicate bandana key 'bamboo.plugin.state'");
                }
            }
        });
        if (StringUtils.isBlank((CharSequence)pluginStoreXml[0])) {
            log.info((Object)"Plugin store is empty, there is nothing to do.");
            return;
        }
        XStream xStream = new XStream();
        PluginPersistentState pluginPersistentState = (PluginPersistentState)xStream.fromXML(pluginStoreXml[0]);
        if (pluginPersistentState == null) {
            return;
        }
        Map statesMap = pluginPersistentState.getStatesMap();
        HashMap updatedState = new HashMap();
        for (Map.Entry entry : statesMap.entrySet()) {
            Boolean value = (Boolean)Narrow.downTo(entry.getValue(), Boolean.class);
            if (value != null) {
                updatedState.put(entry.getKey(), new PluginEnabledState(value.booleanValue(), 0L));
                continue;
            }
            updatedState.put(entry.getKey(), (PluginEnabledState)entry.getValue());
        }
        PluginPersistentState.Builder builder = PluginPersistentState.Builder.create();
        builder.addPluginEnabledState(updatedState);
        PluginPersistentState updatedPluginPersistentState = builder.toState();
        String updatedPluginPersistedStateString = xStream.toXML((Object)updatedPluginPersistentState);
        log.debug((Object)String.format("Upgraded plugin store: [%s]", updatedPluginPersistedStateString));
        this.withDatabaseConnection(connection -> {
            try (PreparedStatement statement = connection.prepareStatement("update BANDANA set SERIALIZED_DATA = ? where BANDANA_KEY = 'bamboo.plugin.state'");){
                statement.setString(1, updatedPluginPersistedStateString);
                statement.executeUpdate();
            }
        });
    }
}

