/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_9;

import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class UpgradeTask60904DropAtlassianUserTables
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60904DropAtlassianUserTables.class);
    @Lazy
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask60904DropAtlassianUserTables() {
        super("Drop Atlassian user tables");
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws HibernateException, SQLException {
        this.dropTableIfPresent(connection, "LOCAL_MEMBERS");
        this.dropTableIfPresent(connection, "EXTERNAL_MEMBERS");
        this.dropTableIfPresent(connection, "EXTERNAL_ENTITIES");
        this.dropTableIfPresent(connection, "USERS");
        this.dropTableIfPresent(connection, "GROUPS");
    }

    private void dropTableIfPresent(@NotNull Connection connection, String tableName) throws SQLException {
        if (this.dbmsBean.isTablePresent(connection, tableName)) {
            this.dbmsBean.dropTable(connection, tableName);
        }
    }
}

