/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_9;

import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask60903AddPlanNameToResults
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60903AddPlanNameToResults.class);
    private static final String updateBrsMySQL = "update BUILDRESULTSUMMARY BRS inner join BUILD B on B.FULL_KEY = BRS.BUILD_KEY  set PLAN_NAME = B.TITLE where PLAN_NAME is null";
    private static final String updateBrs = "update BUILDRESULTSUMMARY set PLAN_NAME = (select TITLE from BUILD B where B.FULL_KEY = BUILDRESULTSUMMARY.BUILD_KEY) where PLAN_NAME is null";
    @Autowired
    private DbmsBean dbmsBean;
    @Autowired
    private BambooTransactionHibernateTemplate transactionTemplate;

    public UpgradeTask60903AddPlanNameToResults() {
        super("Populate PLAN_NAME column in BRS table");
    }

    public void doUpgrade() throws Exception {
        ArrayList affectedJobIds = new ArrayList();
        this.transactionTemplate.doWork(connection -> {
            try (Statement updateBrsStatement = connection.createStatement();){
                if (this.dbmsBean.isMySql()) {
                    updateBrsStatement.executeUpdate(updateBrsMySQL);
                } else {
                    updateBrsStatement.executeUpdate(updateBrs);
                }
            }
        });
    }
}

