/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_9;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.util.ForeignKeyConstraintUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.HashMultimap;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask60901DropFkOnCapabilityTable
extends AbstractBootstrapUpgradeTask {
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask60901DropFkOnCapabilityTable() {
        super("Drop all FK constraints on CAPABILITY table so that they are created with CASCADE");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(c -> {
            HashMultimap<String, String> fksPreDrop = ForeignKeyConstraintUtils.getAllForeignKeyConstraints(this.dbmsBean, c, Collections.singletonList("CAPABILITY"));
            fksPreDrop.entries().forEach(entry -> {
                String constraint = (String)entry.getValue();
                ForeignKeyConstraintUtils.dropForeignKeyConstraint(this.dbmsBean, c, (String)entry.getKey(), constraint);
            });
        });
    }
}

