/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_9;

import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMoveJobDataToChainsUpgradeTask
extends AbstractUpgradeTask {
    private static final String selectMasterAndParent = "select J.MASTER_ID, S.BUILD_ID from BUILD J join CHAIN_STAGE S on J.STAGE_ID = S.STAGE_ID where J.BUILD_ID = ? ";
    @Autowired
    protected BambooTransactionHibernateTemplate transactionTemplate;

    public AbstractMoveJobDataToChainsUpgradeTask(@NotNull String shortDescription) {
        super(shortDescription);
    }

    public void doUpgrade(@NotNull String selectAffectedJobIdsSQL, @NotNull String updateSQL) throws Exception {
        ArrayList affectedJobIds = new ArrayList();
        this.transactionTemplate.doWork(connection -> {
            try (PreparedStatement selectAffectedJobIdsPS = connection.prepareStatement(selectAffectedJobIdsSQL);
                 ResultSet rs = selectAffectedJobIdsPS.executeQuery();){
                while (rs.next()) {
                    affectedJobIds.add(rs.getLong(1));
                }
            }
        });
        for (int i = 0; i < affectedJobIds.size(); i += 100) {
            int start = i;
            this.transactionTemplate.doWork(connection -> {
                try (PreparedStatement selectMasterAndParentPS = connection.prepareStatement(selectMasterAndParent);
                     PreparedStatement updateTestClassesPS = connection.prepareStatement(updateSQL);){
                    for (int j = start; j < start + 100 && j < affectedJobIds.size(); ++j) {
                        selectMasterAndParentPS.setLong(1, (Long)affectedJobIds.get(j));
                        try (ResultSet rs = selectMasterAndParentPS.executeQuery();){
                            rs.next();
                            long masterId = rs.getLong(1);
                            if (rs.wasNull()) {
                                masterId = (Long)affectedJobIds.get(j);
                            }
                            long parentId = rs.getLong(2);
                            updateTestClassesPS.setLong(1, masterId);
                            updateTestClassesPS.setLong(2, parentId);
                            updateTestClassesPS.setLong(3, (Long)affectedJobIds.get(j));
                            updateTestClassesPS.executeUpdate();
                            continue;
                        }
                    }
                }
            });
        }
    }
}

