/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_8;

import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityImpl;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.query.NativeQuery;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask60803ScheduleInitialCleanupOfObsoleteUserData
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60803ScheduleInitialCleanupOfObsoleteUserData.class);
    private static final Map<String, String> ENTITY_TYPE_MAPPINGS = ImmutableMap.of((Object)"PRINCIPAL", (Object)"USER", (Object)"GROUP_PRINCIPAL", (Object)"GROUP");
    private static final List<String> IGNORED_ENTITY_TYPES = ImmutableList.of((Object)"GRANTED_AUTHORITY");
    @Inject
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask60803ScheduleInitialCleanupOfObsoleteUserData() {
        super("Scheduling an initial cleanup of obsolete data stored for deleted users and group");
    }

    public void doUpgrade() {
        log.info((Object)"Copying all Sids from ACL table to the Crowd deleted entities table");
        this.runStatement(new CopyEntitiesFromAclTable());
        for (Map.Entry<String, String> mapping : ENTITY_TYPE_MAPPINGS.entrySet()) {
            log.info((Object)String.format("Fixing values in Crowd deleted entities table - changing %s to %s", mapping.getKey(), mapping.getValue()));
            this.runStatement(new FixMappingOfEntityTypes(mapping.getKey(), mapping.getValue()));
        }
        for (String ignored : IGNORED_ENTITY_TYPES) {
            log.info((Object)String.format("Removing unsupported values from Crowd deleted entities table: %s", ignored));
            this.runStatement(new DeleteIgnoredEntityTypes(ignored));
        }
    }

    private void runStatement(@NotNull UpgradeStatement statement) {
        String sql = this.getSql(statement);
        log.debug((Object)String.format("Running SQL statement: %s", sql));
        this.bambooTransactionHibernateTemplate.execute(session -> {
            NativeQuery nativeQuery = session.createNativeQuery(sql);
            nativeQuery.addSynchronizedEntityClass(CrowdDeletedEntityImpl.class);
            statement.prepareQuery(nativeQuery);
            int affectedRows = nativeQuery.executeUpdate();
            log.debug((Object)String.format("SQL statement affected %d rows", affectedRows));
            return null;
        });
    }

    @NotNull
    private String getSql(@NotNull UpgradeStatement statement) {
        String query = statement.getQuery();
        for (String identifier : statement.getQueryIdentifiers()) {
            query = query.replaceAll("@" + identifier + "@", this.quoteIdentifier(identifier));
        }
        return query;
    }

    @NotNull
    private String quoteIdentifier(@NotNull String identifier) {
        return this.dbmsBean.isMySql() ? this.dbmsBean.quote(identifier) : identifier;
    }

    private class DeleteIgnoredEntityTypes
    implements UpgradeStatement {
        private final String ignoredEntityType;

        private DeleteIgnoredEntityTypes(String ignoredEntityType) {
            this.ignoredEntityType = ignoredEntityType;
        }

        @Override
        @NotNull
        public String getQuery() {
            return "delete from @CROWD_DELETED_ENTITY@ where @ENTITY_TYPE@ = :ignoredEntityType";
        }

        @Override
        @NotNull
        public List<String> getQueryIdentifiers() {
            return Arrays.asList("CROWD_DELETED_ENTITY", "ENTITY_TYPE");
        }

        @Override
        public void prepareQuery(@NotNull NativeQuery<?> query) {
            query.setParameter("ignoredEntityType", (Object)this.ignoredEntityType);
        }
    }

    private class FixMappingOfEntityTypes
    implements UpgradeStatement {
        private final String entityTypeFrom;
        private final String entityTypeTo;

        private FixMappingOfEntityTypes(@NotNull String entityTypeFrom, String entityTypeTo) {
            this.entityTypeFrom = entityTypeFrom;
            this.entityTypeTo = entityTypeTo;
        }

        @Override
        @NotNull
        public String getQuery() {
            return "update @CROWD_DELETED_ENTITY@ set @ENTITY_TYPE@ = :entityTypeTo WHERE @ENTITY_TYPE@ = :entityTypeFrom";
        }

        @Override
        @NotNull
        public List<String> getQueryIdentifiers() {
            return Arrays.asList("CROWD_DELETED_ENTITY", "ENTITY_TYPE");
        }

        @Override
        public void prepareQuery(@NotNull NativeQuery<?> query) {
            query.setParameter("entityTypeFrom", (Object)this.entityTypeFrom);
            query.setParameter("entityTypeTo", (Object)this.entityTypeTo);
        }
    }

    private class CopyEntitiesFromAclTable
    implements UpgradeStatement {
        private CopyEntitiesFromAclTable() {
        }

        @Override
        @NotNull
        public String getQuery() {
            return "insert into @CROWD_DELETED_ENTITY@ (@CROWD_DELETED_ENTITY_ID@, @ENTITY_TYPE@, @ENTITY_NAME@, @DELETION_DATE@) select min(@ID@), @TYPE@, @SID@, :currentDate from @ACL_ENTRY@ group by @TYPE@, @SID@";
        }

        @Override
        @NotNull
        public List<String> getQueryIdentifiers() {
            return Arrays.asList("CROWD_DELETED_ENTITY", "CROWD_DELETED_ENTITY_ID", "ENTITY_TYPE", "ENTITY_NAME", "DELETION_DATE", "ID", "TYPE", "SID", "ACL_ENTRY");
        }

        @Override
        public void prepareQuery(@NotNull NativeQuery<?> query) {
            query.setParameter("currentDate", (Object)LocalDate.now());
        }
    }

    private static interface UpgradeStatement {
        @NotNull
        public String getQuery();

        @NotNull
        public List<String> getQueryIdentifiers();

        public void prepareQuery(@NotNull NativeQuery<?> var1);
    }
}

