/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_7;

import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask60702RearrangeAuditLogTableData
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60702RearrangeAuditLogTableData.class);
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask60702RearrangeAuditLogTableData() {
        super("Move data inside AUDIT_LOG table");
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws HibernateException, SQLException {
        try (Statement st = connection.createStatement();){
            Updater updater = new Updater(this.dbmsBean);
            st.executeUpdate(updater.moveEntityTypeToFieldType());
            log.info((Object)"Copied entity_type to field_type");
            st.executeUpdate(updater.updatePlanRelatedAuditLogRecords());
            log.info((Object)"initialized Plan related entries");
            st.executeUpdate(updater.updateDeploymentRelatedAuditLogRecords());
            log.info((Object)"initialized Deployment related entries");
        }
    }

    private class Updater {
        private final String notNullCondition;
        private final String isPlanCondition;
        private final String isDeploymentCondition;
        private final String childIdValue;
        private final String entityIdValue;

        private Updater(DbmsBean dbmsBean) {
            if (dbmsBean.isH2()) {
                this.notNullCondition = "trim(ENTITY_ID) is not null";
                this.entityIdValue = "SUBSTRING(ENTITY_ID, 0, POSITION('-', ENTITY_ID))";
                this.childIdValue = "SUBSTRING(ENTITY_ID, POSITION('-', ENTITY_ID) + 1)";
                this.isPlanCondition = "LOWER(ENTITY_ID) <> UPPER(ENTITY_ID)";
                this.isDeploymentCondition = "LOWER(ENTITY_ID) = UPPER(ENTITY_ID)";
            } else if (dbmsBean.isMsSqlServer()) {
                this.notNullCondition = "LTRIM(ENTITY_ID) is not null";
                this.entityIdValue = "SUBSTRING(ENTITY_ID, 0, CHARINDEX('-', ENTITY_ID))";
                this.childIdValue = "SUBSTRING(ENTITY_ID, CHARINDEX('-', ENTITY_ID) + 1, 256)";
                this.isPlanCondition = "LOWER(ENTITY_ID) <> UPPER(ENTITY_ID)";
                this.isDeploymentCondition = "LOWER(ENTITY_ID) = UPPER(ENTITY_ID)";
            } else if (dbmsBean.isOracle()) {
                this.notNullCondition = "trim(ENTITY_ID) is not null";
                this.entityIdValue = "SUBSTR(ENTITY_ID, 0, INSTR(ENTITY_ID, '-') - 1)";
                this.childIdValue = "SUBSTR(ENTITY_ID, INSTR(ENTITY_ID, '-') + 1)";
                this.isPlanCondition = "LOWER(ENTITY_ID) <> UPPER(ENTITY_ID)";
                this.isDeploymentCondition = "LOWER(ENTITY_ID) = UPPER(ENTITY_ID)";
            } else if (dbmsBean.isMySql()) {
                this.notNullCondition = "trim(ENTITY_ID) is not null";
                this.entityIdValue = "SUBSTRING_INDEX(ENTITY_ID, '-', 1)";
                this.childIdValue = "SUBSTRING_INDEX(ENTITY_ID, '-', -1)";
                this.isPlanCondition = "ENTITY_ID REGEXP ('^[a-zA-Z]')";
                this.isDeploymentCondition = "ENTITY_ID REGEXP ('^[0-9]')";
            } else {
                this.notNullCondition = "trim(ENTITY_ID) is not null";
                this.entityIdValue = "SUBSTRING(ENTITY_ID, 0, POSITION('-' in ENTITY_ID))";
                this.childIdValue = "SUBSTRING(ENTITY_ID, POSITION('-' in ENTITY_ID) + 1)";
                this.isPlanCondition = "LOWER(ENTITY_ID) <> UPPER(ENTITY_ID)";
                this.isDeploymentCondition = "LOWER(ENTITY_ID) = UPPER(ENTITY_ID)";
            }
        }

        String moveEntityTypeToFieldType() {
            return String.format("update AUDIT_LOG set FIELD_TYPE=ENTITY_TYPE where %s", this.getNotNullCondition());
        }

        String updatePlanRelatedAuditLogRecords() {
            return String.format("update AUDIT_LOG set ENTITY_TYPE='Plan' where %s and %s", this.getNotNullCondition(), this.getIsPlanCondition());
        }

        String updateDeploymentRelatedAuditLogRecords() {
            return String.format("update AUDIT_LOG set ENTITY_TYPE='DeploymentProject', CHILD_ID = %s, ENTITY_ID = %s where %s and %s", this.getChildIdValue(), this.getEntityIdValue(), this.getNotNullCondition(), this.getIsDeploymentCondition());
        }

        String getNotNullCondition() {
            return this.notNullCondition;
        }

        String getIsPlanCondition() {
            return this.isPlanCondition;
        }

        String getIsDeploymentCondition() {
            return this.isDeploymentCondition;
        }

        String getChildIdValue() {
            return this.childIdValue;
        }

        String getEntityIdValue() {
            return this.entityIdValue;
        }
    }
}

