/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_7;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask60701ChangeAuditLogStructure
extends AbstractBootstrapUpgradeTask {
    private static final String TABLE_NAME = "AUDIT_LOG";
    @Autowired
    private DbmsBean dbmsBean;

    protected UpgradeTask60701ChangeAuditLogStructure() {
        super("Rename columns at AUDIT_LOG table to support audit logs for deployment projects");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(connection -> {
            this.dbmsBean.dropIndexIfExists(connection, TABLE_NAME, "plan_time_idx");
            if (!this.dbmsBean.isColumnPresent(connection, TABLE_NAME, "ENTITY_ID")) {
                this.dbmsBean.renameColumn(connection, TABLE_NAME, "PLAN_KEY", "ENTITY_ID");
            }
            if (!this.dbmsBean.isColumnPresent(connection, TABLE_NAME, "CHILD_ID")) {
                this.dbmsBean.renameColumn(connection, TABLE_NAME, "JOB_KEY", "CHILD_ID");
            }
            if (!this.dbmsBean.isColumnPresent(connection, TABLE_NAME, "FIELD_HEADER")) {
                this.dbmsBean.renameColumn(connection, TABLE_NAME, "TASK_HEADER", "FIELD_HEADER");
            }
        });
    }
}

