/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6.ec;

import com.atlassian.bamboo.upgrade.AbstractXmlUpgrader;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.atlassian.user.configuration.xml.XMLConfigurationParser;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class UserConfigurationChecker {
    private static final Logger log = Logger.getLogger(UserConfigurationChecker.class);
    private static final String ATLASSIAN_USER_FILE = "atlassian-user.xml";

    @NotNull
    public static List<RepositoryConfiguration> getAtlassianUserConfiguration(Path configurationDirectory) throws ConfigurationException {
        ByteArrayInputStream configInputStream;
        File atlassianUserFile = configurationDirectory.resolve(ATLASSIAN_USER_FILE).toFile();
        if (!atlassianUserFile.exists()) {
            return Collections.emptyList();
        }
        try {
            configInputStream = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)atlassianUserFile));
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        XMLConfigurationParser legacyConfigParser = new XMLConfigurationParser();
        legacyConfigParser.parse((InputStream)configInputStream);
        return legacyConfigParser.getRepositoryConfigurations();
    }

    public static boolean isUpgradeableLdapConfiguration(RepositoryConfiguration config) {
        return "com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor".equals(config.getComponentClassName("userAdaptor")) && "com.atlassian.user.impl.ldap.search.query.LDAPEntityQueryParser".equals(config.getComponentClassName("entityQueryParser")) && "com.atlassian.user.impl.ldap.DefaultLDAPGroupFactory".equals(config.getComponentClassName("groupFactory")) && "com.atlassian.user.impl.ldap.DefaultLDAPUserFactory".equals(config.getComponentClassName("userFactory")) && "com.atlassian.user.impl.ldap.repository.DefaultLdapContextFactory".equals(config.getComponentClassName("contextFactory")) && "com.atlassian.user.impl.ldap.LDAPUserManagerReadOnly".equals(config.getComponentClassName("userManager")) && "com.atlassian.user.impl.ldap.LDAPGroupManagerReadOnly".equals(config.getComponentClassName("groupManager")) && "com.atlassian.user.impl.ldap.configuration.LdapRepositoryProcessor".equals(config.getComponentClassName("processor")) && "com.atlassian.user.impl.ldap.security.authentication.DefaultLDAPAuthenticator".equals(config.getComponentClassName("authenticator"));
    }

    public static boolean isDefaultConfiguration(RepositoryConfiguration config) {
        return new DefaultRepositoryIdentifier("hibernateRepository", "Hibernate Repository").equals((Object)config.getIdentifier()) && "com.atlassian.user.impl.hibernate3.properties.HibernatePropertySetFactory".equals(config.getComponentClassName("propertySetFactory")) && "com.atlassian.user.impl.hibernate3.HibernateUserManager".equals(config.getComponentClassName("userManager")) && "com.atlassian.user.impl.hibernate3.HibernateGroupManager".equals(config.getComponentClassName("groupManager")) && "com.atlassian.user.impl.as.security.authentication.ASAuthenticator".equals(config.getComponentClassName("authenticator")) && "com.atlassian.user.impl.hibernate3.repository.DefaultHibernateRepository".equals(config.getComponentClassName("hibernateProvider"));
    }

    public static boolean isUpgradeableCrowdConfiguration(RepositoryConfiguration config) {
        return "com.atlassian.user.impl.hibernate3.CachingExternalEntityDAO".equals(config.getComponentClassName("externalEntityDAO")) && "com.atlassian.user.impl.hibernate3.repository.DefaultHibernateRepository".equals(config.getComponentClassName("hibernateProvider")) && "com.atlassian.user.impl.hibernate3.properties.HibernatePropertySetFactory".equals(config.getComponentClassName("propertySetFactory")) && "com.atlassian.user.impl.hibernate3.configuration.HibernateRepositoryProcessor".equals(config.getComponentClassName("processor")) && "com.atlassian.crowd.integration.atlassianuser.CrowdUserManager".equals(config.getComponentClassName("userManager")) && "com.atlassian.crowd.integration.atlassianuser.CrowdGroupManager".equals(config.getComponentClassName("groupManager")) && "com.atlassian.crowd.integration.atlassianuser.CrowdAuthenticator".equals(config.getComponentClassName("authenticator")) && "com.atlassian.crowd.integration.atlassianuser.CrowdEntityQueryParser".equals(config.getComponentClassName("entityQueryParser"));
    }

    public static void appendDeprecationInfo() {
        URL url = ClassLoaderUtils.getResource((String)ATLASSIAN_USER_FILE, UserConfigurationChecker.class);
        File atlassianUser = new File(url.getPath());
        try {
            AbstractXmlUpgrader.appendComment((String)"This file is not used anymore.", (File)atlassianUser);
        }
        catch (IOException e) {
            log.error((Object)"Could not append deprecation info to atlassian-user.xml", (Throwable)e);
        }
    }
}

