/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6.ec;

import com.atlassian.bamboo.util.BambooHibernateUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;

public abstract class SessionClearingRowCallbackHandler
implements RowCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(SessionClearingRowCallbackHandler.class);
    private final int flushAndClearEvery;
    private final int expectedTotal;
    private final Session session;

    SessionClearingRowCallbackHandler(Session session, int flushAndClearEvery, int expectedTotal) {
        this.flushAndClearEvery = flushAndClearEvery;
        this.expectedTotal = expectedTotal;
        this.session = session;
    }

    public final void processRow(ResultSet rs) throws SQLException {
        this.processRowInternal(rs);
        if (rs.getRow() % this.flushAndClearEvery == 0) {
            log.info("Processed {} of {}...", (Object)rs.getRow(), (Object)this.expectedTotal);
            SessionClearingRowCallbackHandler.flushAndClear(this.session);
        }
    }

    private static void flushAndClear(Session session) {
        try {
            BambooHibernateUtils.flushIfNeeded((Session)session);
            session.clear();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void processRowInternal(ResultSet var1) throws SQLException;
}

