/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6.ec;

import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.RepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.UserConfigurationChecker;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.crowd.directory.GenericLDAP;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PermissionOption;
import com.atlassian.crowd.embedded.impl.DefaultConnectionPoolProperties;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.user.configuration.RepositoryConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ldap.BadLdapGrammarException;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapRdn;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;
import org.springframework.ldap.filter.PresentFilter;

public class LdapRepositoryConfigurationMigrator
implements RepositoryConfigurationMigrator {
    public static final Logger log = Logger.getLogger(LdapRepositoryConfigurationMigrator.class);
    private final CrowdDirectoryService crowdDirectoryService;
    private final LDAPPropertiesHelper ldapPropertiesHelper;

    public LdapRepositoryConfigurationMigrator(CrowdDirectoryService crowdDirectoryService, LDAPPropertiesHelper ldapPropertiesHelper) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.ldapPropertiesHelper = ldapPropertiesHelper;
    }

    @Override
    public boolean matches(RepositoryConfiguration repositoryConfiguration) {
        return UserConfigurationChecker.isUpgradeableLdapConfiguration(repositoryConfiguration);
    }

    @Override
    public List<String> validate(RepositoryConfiguration repositoryConfiguration) {
        ArrayList<String> errors = new ArrayList<String>();
        this.validateIdentifierExists(errors, repositoryConfiguration);
        this.validateOptionalDistinguishedName(errors, repositoryConfiguration, "baseGroupNamespace");
        this.validateOptionalDistinguishedName(errors, repositoryConfiguration, "baseUserNamespace");
        if (repositoryConfiguration.getStringComponent("securityPrincipal") != null) {
            this.validateSecurityPrincipal(errors, repositoryConfiguration);
            this.validateStringComponentExists(errors, repositoryConfiguration, "securityCredential");
        }
        this.validateStringComponentExists(errors, repositoryConfiguration, "groupnameAttribute");
        this.validateObjectClassDefined(errors, repositoryConfiguration, "groupSearchFilter");
        this.validateStringComponentExists(errors, repositoryConfiguration, "membershipAttribute");
        this.validateStringComponentExists(errors, repositoryConfiguration, "firstnameAttribute");
        this.validateStringComponentExists(errors, repositoryConfiguration, "surnameAttribute");
        this.validateObjectClassDefined(errors, repositoryConfiguration, "userSearchFilter");
        this.validateStringComponentExists(errors, repositoryConfiguration, "usernameAttribute");
        this.validateStringComponentExists(errors, repositoryConfiguration, "emailAttribute");
        this.validateOptionalInteger(errors, repositoryConfiguration, "initSize");
        this.validateOptionalInteger(errors, repositoryConfiguration, "prefSize");
        this.validateOptionalInteger(errors, repositoryConfiguration, "maxSize");
        this.validateOptionalInteger(errors, repositoryConfiguration, "timeout");
        this.validateOptionalInteger(errors, repositoryConfiguration, "timeToLive");
        this.validateOptionalInteger(errors, repositoryConfiguration, "connectTimeout");
        this.validateOptionalInteger(errors, repositoryConfiguration, "readTimeout");
        return errors;
    }

    private void validateSecurityPrincipal(List<String> errors, RepositoryConfiguration repositoryConfiguration) {
        String key = "securityPrincipal";
        String securityPrincipal = repositoryConfiguration.getStringComponent("securityPrincipal");
        boolean containsAtChar = StringUtils.contains((CharSequence)securityPrincipal, (CharSequence)"@");
        if (this.isActiveDirectory(repositoryConfiguration) && containsAtChar) {
            log.info((Object)"Found AD configuration and securityPrincipal has @ sign. It's a valid AD configuration, skip check for DN format.");
            return;
        }
        if (containsAtChar) {
            log.info((Object)"AD configuration not detected and securityPrincipal has @ sign. If your external user directory is Active Directory and the securityPrincipal is a valid UPN, you can force Active Directory detection with the system property -Dbamboo.upgrade.active.directory=true");
        }
        this.validateOptionalDistinguishedName(errors, repositoryConfiguration, "securityPrincipal");
    }

    private void validateIdentifierExists(List<String> errors, RepositoryConfiguration repositoryConfiguration) {
        if (repositoryConfiguration.getIdentifier() == null) {
            log.error((Object)"Missing repository key or name");
            errors.add("Missing repository key or name");
        }
    }

    private void validateOptionalDistinguishedName(List<String> errors, RepositoryConfiguration repositoryConfiguration, String componentName) {
        try {
            new DistinguishedName(repositoryConfiguration.getStringComponent(componentName));
        }
        catch (BadLdapGrammarException e) {
            log.error((Object)("Property " + componentName + " is not a valid distinguished name: " + e.getMessage()));
            errors.add("Property " + componentName + " is not a valid distinguished name");
        }
    }

    private void validateObjectClassDefined(List<String> errors, RepositoryConfiguration repositoryConfiguration, String componentName) {
        if (this.validateStringComponentExists(errors, repositoryConfiguration, componentName) && this.extractObjectClass(repositoryConfiguration.getStringComponent(componentName)) == null) {
            if (this.isActiveDirectory(repositoryConfiguration)) {
                if (this.validateStringComponentExists(errors, repositoryConfiguration, componentName) && this.extractObjectCategory(repositoryConfiguration.getStringComponent(componentName)) == null) {
                    log.error((Object)("Property " + componentName + " does not define objectClass or objectCategory filter"));
                    errors.add("Property " + componentName + " does not define objectClass or objectCategory filter");
                }
            } else {
                log.error((Object)("Property " + componentName + " does not define an objectClass filter"));
                errors.add("Property " + componentName + " does not define an objectClass filter");
            }
        }
    }

    private boolean validateStringComponentExists(List<String> errors, RepositoryConfiguration repositoryConfiguration, String componentName) {
        if (repositoryConfiguration.getStringComponent(componentName) == null) {
            log.error((Object)("Missing required property " + componentName));
            errors.add("Missing required property " + componentName);
            return false;
        }
        return true;
    }

    private boolean validateOptionalInteger(List<String> errors, RepositoryConfiguration repositoryConfiguration, String componentName) {
        String str = repositoryConfiguration.getStringComponent(componentName);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                Integer.valueOf(str, 10);
            }
            catch (NumberFormatException e) {
                errors.add("Property " + componentName + " is not a number");
                return false;
            }
        }
        return true;
    }

    @Override
    public Pair<Directory, RepositoryConfigurationMigrator> migrateAndTestConnection(RepositoryConfiguration repositoryConfiguration) {
        LdapRdn userRdn;
        LdapRdn groupRdn;
        int i;
        String implementationClassName = this.getImplementationClassName(repositoryConfiguration);
        String directoryName = "Upgraded atlassian-user LDAP (" + repositoryConfiguration.getIdentifier().getKey() + ")";
        DirectoryImpl ldapDirectory = new DirectoryImpl(directoryName, DirectoryType.CONNECTOR, implementationClassName);
        Properties properties = (Properties)this.ldapPropertiesHelper.getConfigurationDetails().get(implementationClassName);
        if (properties != null) {
            log.info((Object)("loading default properties from [ " + implementationClassName + " ] implementation"));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                ldapDirectory.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        ldapDirectory.setDescription("LDAP configuration upgraded from an existing atlassian-user configuration");
        ldapDirectory.setActive(true);
        ldapDirectory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
        ldapDirectory.setAttribute("useNestedGroups", Boolean.TRUE.toString());
        ldapDirectory.setAttribute("ldap.nestedgroups.disabled", Boolean.FALSE.toString());
        ldapDirectory.setAttribute("ldap.url", this.makeLdapUrl(repositoryConfiguration));
        ldapDirectory.setAttribute("ldap.secure", this.getSecureSetting(repositoryConfiguration));
        ldapDirectory.setAttribute("directory.cache.synchronise.interval", String.valueOf(3600));
        ldapDirectory.setAttribute("crowd.sync.group.membership.after.successful.user.auth.enabled", SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.WHEN_AUTHENTICATION_CREATED_THE_USER.getValue());
        ldapDirectory.setAttribute("ldap.local.groups", "true");
        ldapDirectory.setAllowedOperations(PermissionOption.READ_ONLY_LOCAL_GROUPS.getAllowedOperations());
        String baseGroupNamespace = repositoryConfiguration.getStringComponent("baseGroupNamespace");
        String baseUserNamespace = repositoryConfiguration.getStringComponent("baseUserNamespace");
        DistinguishedName baseContextDN = new DistinguishedName();
        DistinguishedName baseGroupNamespaceDN = new DistinguishedName(baseGroupNamespace);
        DistinguishedName baseUserNamespaceDN = new DistinguishedName(baseUserNamespace);
        int minLength = Math.min(baseGroupNamespaceDN.size(), baseUserNamespaceDN.size());
        for (i = 0; i < minLength && (groupRdn = baseGroupNamespaceDN.getLdapRdn(i)).equals((Object)(userRdn = baseUserNamespaceDN.getLdapRdn(i))); ++i) {
            baseContextDN.add(groupRdn);
        }
        for (i = 0; i < baseContextDN.size(); ++i) {
            baseGroupNamespaceDN.removeFirst();
            baseUserNamespaceDN.removeFirst();
        }
        ldapDirectory.setAttribute("ldap.basedn", baseContextDN.toCompactString());
        ldapDirectory.setAttribute("ldap.userdn", repositoryConfiguration.getStringComponent("securityPrincipal"));
        ldapDirectory.setAttribute("ldap.password", repositoryConfiguration.getStringComponent("securityCredential"));
        ldapDirectory.setAttribute("ldap.group.dn", baseGroupNamespaceDN.toCompactString());
        ldapDirectory.setAttribute("ldap.group.description", repositoryConfiguration.getStringComponent("groupnameAttribute"));
        ldapDirectory.setAttribute("ldap.group.name", repositoryConfiguration.getStringComponent("groupnameAttribute"));
        ldapDirectory.setAttribute("ldap.group.objectclass", this.extractObjectClassOrCategory(repositoryConfiguration, "groupSearchFilter"));
        ldapDirectory.setAttribute("ldap.group.filter", repositoryConfiguration.getStringComponent("groupSearchFilter"));
        ldapDirectory.setAttribute("ldap.group.usernames", repositoryConfiguration.getStringComponent("membershipAttribute"));
        ldapDirectory.setAttribute("ldap.user.dn", baseUserNamespaceDN.toCompactString());
        ldapDirectory.setAttribute("ldap.user.firstname", repositoryConfiguration.getStringComponent("firstnameAttribute"));
        ldapDirectory.setAttribute("ldap.user.lastname", repositoryConfiguration.getStringComponent("surnameAttribute"));
        ldapDirectory.setAttribute("ldap.user.objectclass", this.extractObjectClassOrCategory(repositoryConfiguration, "userSearchFilter"));
        String usernameAttribute = repositoryConfiguration.getStringComponent("usernameAttribute");
        String userSearchFilterStr = this.getRefinedUserSearchFilter(repositoryConfiguration.getStringComponent("userSearchFilter"), usernameAttribute);
        ldapDirectory.setAttribute("ldap.user.filter", userSearchFilterStr);
        ldapDirectory.setAttribute("ldap.user.username", usernameAttribute);
        ldapDirectory.setAttribute("ldap.user.username.rdn", usernameAttribute);
        ldapDirectory.setAttribute("ldap.user.email", repositoryConfiguration.getStringComponent("emailAttribute"));
        ldapDirectory.setAttribute("ldap.usermembership.use", "false");
        ldapDirectory.setAttribute("ldap.usermembership.use.for.groups", "false");
        ldapDirectory.setAttribute("ldap.relaxed.dn.standardisation", "false");
        if (this.isActiveDirectory(repositoryConfiguration)) {
            ldapDirectory.setAttribute("ldap.pagedresults", "true");
            ldapDirectory.setAttribute("ldap.pagedresults.size", "1000");
            ldapDirectory.setAttribute("crowd.sync.incremental.enabled", Boolean.TRUE.toString());
        }
        ldapDirectory.setAttribute("ldap.roles.disabled", "true");
        ldapDirectory.setAttribute("ldap.pooling", repositoryConfiguration.getStringComponent("poolingOn"));
        DefaultConnectionPoolProperties connectionPoolProperties = new DefaultConnectionPoolProperties();
        if (repositoryConfiguration.hasComponent("initSize")) {
            connectionPoolProperties.setInitialSize(repositoryConfiguration.getStringComponent("initSize"));
        }
        if (repositoryConfiguration.hasComponent("prefSize")) {
            connectionPoolProperties.setPreferredSize(repositoryConfiguration.getStringComponent("prefSize"));
        }
        if (repositoryConfiguration.hasComponent("maxSize")) {
            connectionPoolProperties.setMaximumSize(repositoryConfiguration.getStringComponent("maxSize"));
        }
        if (repositoryConfiguration.hasComponent("timeout")) {
            connectionPoolProperties.setTimeoutInSec(repositoryConfiguration.getStringComponent("timeout"));
        }
        this.crowdDirectoryService.setConnectionPoolProperties((ConnectionPoolProperties)connectionPoolProperties);
        this.setOptionalAttribute(ldapDirectory, "ldap.search.timelimit", repositoryConfiguration.getStringComponent("timeToLive"));
        this.setOptionalAttribute(ldapDirectory, "ldap.connection.timeout", repositoryConfiguration.getStringComponent("connectTimeout"));
        this.setOptionalAttribute(ldapDirectory, "ldap.read.timeout", repositoryConfiguration.getStringComponent("readTimeout"));
        log.info((Object)("Migrated LDAP repository: " + repositoryConfiguration.getIdentifier().getName()));
        if (SystemProperty.EC_UPGRADE_TEST_CONNECTION_ENABLED.getTypedValue()) {
            this.crowdDirectoryService.testConnection((Directory)ldapDirectory);
        }
        return Pair.make((Object)ldapDirectory, (Object)this);
    }

    @Override
    public Directory persistMigratedConfiguration(Directory directory) {
        return this.crowdDirectoryService.addDirectory(directory);
    }

    protected String extractObjectClassOrCategory(RepositoryConfiguration repositoryConfiguration, String searchFilterComponent) {
        String searchFilter = repositoryConfiguration.getStringComponent(searchFilterComponent);
        String objectClass = this.extractObjectClass(searchFilter);
        if (objectClass == null && this.isActiveDirectory(repositoryConfiguration)) {
            log.debug((Object)"ObjectClass is null and AD detected. Falling back to objectCategory filter component");
            return this.extractObjectCategory(searchFilter);
        }
        return objectClass;
    }

    private String getRefinedUserSearchFilter(String userSearchFilterStr, String usernameAttribute) {
        if (!userSearchFilterStr.contains(usernameAttribute + "=")) {
            AndFilter userSearchFilter = new AndFilter();
            userSearchFilter.and((Filter)new HardcodedFilter(userSearchFilterStr));
            userSearchFilter.and((Filter)new PresentFilter(usernameAttribute));
            userSearchFilterStr = userSearchFilter.encode();
        }
        return userSearchFilterStr;
    }

    private String getImplementationClassName(RepositoryConfiguration oldLdapConfig) {
        return this.isActiveDirectory(oldLdapConfig) ? MicrosoftActiveDirectory.class.getName() : GenericLDAP.class.getName();
    }

    private boolean isActiveDirectory(RepositoryConfiguration oldLdapConfig) {
        boolean forceActiveDirectory = Boolean.valueOf(System.getProperty("bamboo.upgrade.active.directory"));
        boolean matchingUsernameAttribute = oldLdapConfig.getStringComponent("usernameAttribute").equalsIgnoreCase("sAMAccountName");
        return forceActiveDirectory || matchingUsernameAttribute;
    }

    private void setOptionalAttribute(DirectoryImpl ldapDirectory, String crowdPropertyKey, String atlassianUserPropertyValue) {
        if (StringUtils.isNotBlank((CharSequence)atlassianUserPropertyValue)) {
            ldapDirectory.setAttribute(crowdPropertyKey, atlassianUserPropertyValue);
        }
    }

    private String extractObjectClass(String ldapSearch) {
        Pattern pat = Pattern.compile("objectClass=([^)]*)");
        Matcher matcher = pat.matcher(ldapSearch);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String extractObjectCategory(String ldapSearch) {
        Pattern pat = Pattern.compile("objectCategory=([^)]*)");
        Matcher matcher = pat.matcher(ldapSearch);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getSecureSetting(RepositoryConfiguration oldLdapConfig) {
        return Boolean.toString("ssl".equals(oldLdapConfig.getStringComponent("securityProtocol")));
    }

    private String makeLdapUrl(RepositoryConfiguration oldLdapConfig) {
        StringBuilder buf = new StringBuilder(25);
        buf.append("ldap://");
        buf.append(oldLdapConfig.getStringComponent("host"));
        buf.append(":");
        if (oldLdapConfig.hasComponent("port")) {
            buf.append(oldLdapConfig.getStringComponent("port"));
        } else {
            buf.append("389");
        }
        return buf.toString();
    }
}

