/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6.ec;

import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigrationException;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.CrowdPropertiesPersister;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.RepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.UserConfigurationChecker;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PermissionOption;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.util.InternalEntityUtils;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CrowdRepositoryConfigurationMigrator
implements RepositoryConfigurationMigrator {
    private static final Logger log = Logger.getLogger(CrowdRepositoryConfigurationMigrator.class);
    private static final String APPLICATION_NAME = "application.name";
    private static final String APPLICATION_PASSWORD = "application.password";
    @VisibleForTesting
    public static final String CROWD_BASE_URL = "crowd.base.url";
    @VisibleForTesting
    public static final String CROWD_SERVER_URL = "crowd.server.url";
    private final CrowdPropertiesPersister crowdPropertiesPersister;
    private final CrowdDirectoryService crowdDirectoryService;

    public CrowdRepositoryConfigurationMigrator(CrowdDirectoryService crowdDirectoryService, CrowdPropertiesPersister crowdPropertiesPersister) {
        this.crowdPropertiesPersister = crowdPropertiesPersister;
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Override
    public List<String> validate(RepositoryConfiguration repositoryConfiguration) {
        ArrayList<String> errors = new ArrayList<String>();
        Properties props = this.crowdPropertiesPersister.getProperties();
        this.validateIdentifierExists(errors, repositoryConfiguration);
        this.validateBaseUrlProperty(errors, props);
        this.validateConfigFileProperty(errors, props, APPLICATION_NAME);
        this.validateConfigFileProperty(errors, props, APPLICATION_PASSWORD);
        return errors;
    }

    @Override
    public Pair<Directory, RepositoryConfigurationMigrator> migrateAndTestConnection(RepositoryConfiguration repositoryConfiguration) throws AtlassianUserMigrationException {
        log.info((Object)("Migrating remote Crowd user management: " + repositoryConfiguration.getIdentifier()));
        Properties props = this.crowdPropertiesPersister.getProperties();
        String directoryName = this.getValidatedDirectoryName(repositoryConfiguration);
        DirectoryImpl crowdDirectory = new DirectoryImpl(directoryName, DirectoryType.CROWD, RemoteCrowdDirectory.class.getName());
        crowdDirectory.setDescription("External Crowd service upgraded from an existing atlassian-user configuration");
        crowdDirectory.setAllowedOperations(PermissionOption.READ_ONLY.getAllowedOperations());
        crowdDirectory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
        crowdDirectory.setAttribute("crowd.sync.incremental.enabled", Boolean.TRUE.toString());
        crowdDirectory.setAttribute("directory.cache.synchronise.interval", String.valueOf(3600));
        crowdDirectory.setAttribute("useNestedGroups", Boolean.TRUE.toString());
        crowdDirectory.setAttribute("crowd.sync.group.membership.after.successful.user.auth.enabled", SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS.getValue());
        crowdDirectory.setAttribute(CROWD_SERVER_URL, this.getValidatedBaseUrlProperty(props));
        this.setRequiredDirectoryProperty(props, crowdDirectory, APPLICATION_NAME, APPLICATION_NAME);
        this.setRequiredDirectoryProperty(props, crowdDirectory, APPLICATION_PASSWORD, APPLICATION_PASSWORD);
        if (SystemProperty.EC_UPGRADE_TEST_CONNECTION_ENABLED.getTypedValue()) {
            this.crowdDirectoryService.testConnection((Directory)crowdDirectory);
        }
        return Pair.make((Object)crowdDirectory, (Object)this);
    }

    @Override
    public Directory persistMigratedConfiguration(Directory directory) {
        return this.crowdDirectoryService.addDirectory(directory);
    }

    private void validateIdentifierExists(List<String> errors, RepositoryConfiguration repositoryConfiguration) {
        if (repositoryConfiguration.getIdentifier() == null) {
            log.error((Object)"Missing repository key or name");
            errors.add("Missing repository key or name");
        }
    }

    private String getValidatedDirectoryName(RepositoryConfiguration repositoryConfiguration) {
        String directoryName = repositoryConfiguration.getIdentifier().getName();
        Validate.notNull((Object)directoryName);
        InternalEntityUtils.validateLength((String)directoryName);
        return directoryName;
    }

    private void validateBaseUrlProperty(List<String> errors, Properties props) {
        if (!props.containsKey(CROWD_BASE_URL) && !props.containsKey(CROWD_SERVER_URL)) {
            log.error((Object)("Crowd configuration in " + this.crowdPropertiesPersister.getLocation() + " does not contain required key: " + CROWD_BASE_URL));
            errors.add("Crowd configuration in " + this.crowdPropertiesPersister.getLocation() + " does not contain required key: " + CROWD_BASE_URL);
        }
    }

    @VisibleForTesting
    protected String getValidatedBaseUrlProperty(Properties props) throws AtlassianUserMigrationException {
        if (!props.containsKey(CROWD_BASE_URL)) {
            if (!props.containsKey(CROWD_SERVER_URL)) {
                throw new AtlassianUserMigrationException("Crowd configuration in " + this.crowdPropertiesPersister.getLocation() + " does not contain required key: " + CROWD_BASE_URL);
            }
            return this.generateBaseUrl(props.getProperty(CROWD_SERVER_URL));
        }
        return props.getProperty(CROWD_BASE_URL);
    }

    private String generateBaseUrl(@NotNull String serverUrl) {
        try {
            URI uri = new URI(serverUrl);
            URI truncatedUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), CrowdRepositoryConfigurationMigrator.truncatePath(uri.getPath()), uri.getQuery(), uri.getFragment());
            return truncatedUri.toString();
        }
        catch (URISyntaxException e) {
            return serverUrl;
        }
    }

    private static String truncatePath(String originalPath) {
        String noTrailingSlashPath = StringUtils.removeEnd((String)originalPath, (String)"/");
        String noCrowdServicePath = StringUtils.removeEnd((String)noTrailingSlashPath, (String)"/services");
        String noSecurityServerPath = StringUtils.removeEnd((String)noTrailingSlashPath, (String)"/services/SecurityServer");
        if (noCrowdServicePath.length() < noSecurityServerPath.length()) {
            return noCrowdServicePath;
        }
        return noSecurityServerPath;
    }

    private void validateConfigFileProperty(List<String> errors, Properties props, String configFilePropertyKey) {
        if (!props.containsKey(configFilePropertyKey)) {
            log.error((Object)("Crowd configuration in " + this.crowdPropertiesPersister.getLocation() + " does not contain required key: " + configFilePropertyKey));
            errors.add("Crowd configuration in " + this.crowdPropertiesPersister.getLocation() + " does not contain required key: " + configFilePropertyKey);
        }
    }

    private String getValidatedConfigFileProperty(Properties props, String configFilePropertyKey) throws AtlassianUserMigrationException {
        if (!props.containsKey(configFilePropertyKey)) {
            throw new AtlassianUserMigrationException("Crowd configuration in " + this.crowdPropertiesPersister.getLocation() + " does not contain required key: " + configFilePropertyKey);
        }
        return props.getProperty(configFilePropertyKey);
    }

    private void setRequiredDirectoryProperty(Properties props, DirectoryImpl crowdDirectory, String configFilePropertyKey, String directoryPropertyKey) throws AtlassianUserMigrationException {
        crowdDirectory.setAttribute(directoryPropertyKey, this.getValidatedConfigFileProperty(props, configFilePropertyKey));
    }

    @Override
    public boolean matches(RepositoryConfiguration repositoryConfiguration) {
        return UserConfigurationChecker.isUpgradeableCrowdConfiguration(repositoryConfiguration);
    }
}

