/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6.ec;

import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.CrowdPropertiesPersister;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.ClientResourceLocator;
import com.atlassian.user.util.ClassLoaderUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class CrowdPropertiesPersisterImpl
implements CrowdPropertiesPersister {
    private final File configurationFile;

    public CrowdPropertiesPersisterImpl(File configurationDirectory) throws IOException {
        this.configurationFile = new File(configurationDirectory, "crowd.properties");
        if (!this.configurationFile.exists()) {
            URL sampleConfigurationFile = ClassLoaderUtils.getResource((String)"crowd.properties", this.getClass());
            FileUtils.copyURLToFile((URL)sampleConfigurationFile, (File)this.configurationFile);
        }
    }

    @Override
    public Properties getProperties() {
        return new ClientResourceLocator("crowd.properties", this.configurationFile.getParent()).getProperties();
    }

    @Override
    public void setProperties(@NotNull Properties properties) throws IOException {
        Properties currentProperties = new Properties();
        try (FileInputStream is = new FileInputStream(this.configurationFile);){
            currentProperties.load(is);
        }
        for (String propertyName : properties.stringPropertyNames()) {
            if (this.isWritable(propertyName)) continue;
            properties.setProperty(propertyName, currentProperties.getProperty(propertyName, ""));
        }
        var4_4 = null;
        try (FileOutputStream os = new FileOutputStream(this.configurationFile);){
            properties.store(os, null);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Override
    public boolean isWritable(@NotNull String propertyName) {
        if (System.getProperty("crowd.properties") != null) {
            return false;
        }
        return new ClientPropertiesImpl(){}.loadPropertyString(null, propertyName) == null;
    }

    @Override
    @NotNull
    public File getLocation() {
        return this.configurationFile;
    }
}

