/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6.ec;

import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigrationException;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.RepositoryConfigurationMigrator;
import com.atlassian.user.configuration.RepositoryConfiguration;
import java.util.List;

public class AtlassianUserMigratorFactory {
    private final List<RepositoryConfigurationMigrator> configurationMigrators;

    public AtlassianUserMigratorFactory(List<RepositoryConfigurationMigrator> configurationMigrators) {
        this.configurationMigrators = configurationMigrators;
    }

    public AtlassianUserMigrator getMigrator(List<RepositoryConfiguration> configuration) throws AtlassianUserMigrationException {
        AtlassianUserMigrator atlassianUserMigrator = new AtlassianUserMigrator();
        for (RepositoryConfiguration repositoryConfiguration : configuration) {
            RepositoryConfigurationMigrator matchedConfigurationMigrator = null;
            for (RepositoryConfigurationMigrator respositoryConfigurationMigrator : this.configurationMigrators) {
                if (!respositoryConfigurationMigrator.matches(repositoryConfiguration)) continue;
                matchedConfigurationMigrator = respositoryConfigurationMigrator;
            }
            if (matchedConfigurationMigrator != null) {
                atlassianUserMigrator.addMigrator(repositoryConfiguration, matchedConfigurationMigrator);
                continue;
            }
            throw new AtlassianUserMigrationException("no matching migrator found for [ " + repositoryConfiguration + " ] " + repositoryConfiguration.getIdentifier());
        }
        return atlassianUserMigrator;
    }
}

