/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6.ec;

import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigrationException;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.RepositoryConfigurationMigrator;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.user.configuration.RepositoryConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtlassianUserMigrator {
    public static final Logger log = Logger.getLogger(AtlassianUserMigrator.class);
    private final List<String> repositoryOrder = new LinkedList<String>();
    private final Map<String, RepositoryConfigurationMigrator> migratorsMap = new HashMap<String, RepositoryConfigurationMigrator>();
    private final Map<String, RepositoryConfiguration> configurationMap = new HashMap<String, RepositoryConfiguration>();

    public void addMigrator(RepositoryConfiguration repositoryConfiguration, RepositoryConfigurationMigrator configurationMigrator) {
        String key = repositoryConfiguration.getIdentifier().getKey();
        this.migratorsMap.put(key, configurationMigrator);
        this.configurationMap.put(key, repositoryConfiguration);
        this.repositoryOrder.add(key);
    }

    public List<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        for (String key : this.repositoryOrder) {
            RepositoryConfiguration config = this.configurationMap.get(key);
            RepositoryConfigurationMigrator configurationMigrator = this.migratorsMap.get(key);
            log.info((Object)("Validating repository [" + key + "]"));
            List<String> migratorErrors = configurationMigrator.validate(config);
            if (migratorErrors != null) {
                errors.addAll(migratorErrors);
            }
            log.info((Object)("Validated repository [" + key + "] with [" + configurationMigrator + "]"));
        }
        return errors;
    }

    public List<Pair<Directory, RepositoryConfigurationMigrator>> migrateAndTestConnections() throws AtlassianUserMigrationException {
        ArrayList<Pair<Directory, RepositoryConfigurationMigrator>> result = new ArrayList<Pair<Directory, RepositoryConfigurationMigrator>>();
        for (String key : this.repositoryOrder) {
            RepositoryConfiguration config = this.configurationMap.get(key);
            RepositoryConfigurationMigrator configurationMigrator = this.migratorsMap.get(key);
            Pair<Directory, RepositoryConfigurationMigrator> migrated = configurationMigrator.migrateAndTestConnection(config);
            if (migrated != null) {
                result.add(migrated);
            }
            log.info((Object)("migrated repository [" + key + "] with [" + configurationMigrator + "]"));
        }
        return result;
    }

    public List<Directory> persistMigratedConfigurations(List<Pair<Directory, RepositoryConfigurationMigrator>> migrated) {
        ArrayList<Directory> result = new ArrayList<Directory>();
        for (Pair<Directory, RepositoryConfigurationMigrator> dir : migrated) {
            result.add(((RepositoryConfigurationMigrator)dir.getSecond()).persistMigratedConfiguration((Directory)dir.getFirst()));
        }
        return result;
    }

    public int getMigratorCount() {
        return this.repositoryOrder.size();
    }
}

