/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6.ec;

import com.atlassian.bamboo.migration.stream.userdata.LocalGroupMapper;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.DataAccessUtils;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.SessionClearingRowCallbackHandler;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.BambooThrowables;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.util.UserUtils;
import com.google.common.base.Throwables;
import com.google.gson.Gson;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public final class AtlassianUserDataMigrator {
    private static final Logger log = LoggerFactory.getLogger(AtlassianUserDataMigrator.class);
    private static final String DEFAULT_BLANK = "-";
    private static final int BATCH_SIZE = 100;
    private final SessionFactory sessionFactory;
    private final UserDao userDao;
    private final GroupDao groupDao;
    private final MembershipDao membershipDao;
    private final CrowdService crowdService;
    private final DirectoryManager directoryManager;
    private final Map<String, Group> localGroups = new HashMap<String, Group>();
    @Lazy
    @Inject
    private DbmsBean dbmsBean;
    @Inject
    private BootstrapManager bootstrapManager;

    public AtlassianUserDataMigrator(SessionFactory sessionFactory, UserDao userDao, GroupDao groupDao, MembershipDao membershipDao, CrowdService crowdService, DirectoryManager directoryManager) {
        this.sessionFactory = sessionFactory;
        this.userDao = userDao;
        this.groupDao = groupDao;
        this.membershipDao = membershipDao;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
    }

    public void migrateUserProperties(Directory internalDirectory, Connection connection) {
        JdbcTemplate jdbcTemplate = DataAccessUtils.getJdbcTemplate(connection);
        int totalUsers = (Integer)jdbcTemplate.queryForObject("select count(distinct ENTITY_NAME) from OS_PROPERTYENTRY", Integer.TYPE);
        int totalProperties = (Integer)jdbcTemplate.queryForObject("select count(*) from OS_PROPERTYENTRY", Integer.TYPE);
        log.info("Copying {} properties for {} users...", (Object)totalProperties, (Object)totalUsers);
        int userCount = 0;
        HashSet<String> processedUsers = new HashSet<String>();
        for (PropertyEntryTuple entityIdAndName : AtlassianUserDataMigrator.getEntityIdsAndNamesOrderedByDate(jdbcTemplate)) {
            Long entityId = entityIdAndName.getId();
            String entityName = entityIdAndName.getName();
            String userName = AtlassianUserDataMigrator.toUserName(entityName);
            if (processedUsers.contains(userName)) {
                try {
                    jdbcTemplate.update("delete from OS_PROPERTYENTRY where ENTITY_NAME= ?", (Object[])new String[]{entityName});
                }
                catch (DataAccessException e) {
                    log.info("Old properties for user " + entityName + " could not be deleted from the database.");
                }
            } else {
                if (entityName.startsWith("LOC")) {
                    LegacyDeactivatedFlagMigrator migrator = new LegacyDeactivatedFlagMigrator(this.userDao, internalDirectory.getId(), userName);
                    jdbcTemplate.query("select BOOLEAN_VAL from OS_PROPERTYENTRY where ENTITY_NAME = ? and ENTITY_KEY = ?", (Object[])new String[]{entityName, "confluence.user.deactivated"}, (RowCallbackHandler)migrator);
                }
                try {
                    jdbcTemplate.update("update OS_PROPERTYENTRY set ENTITY_ID = 0, ENTITY_NAME = ? where ENTITY_NAME = ? AND ENTITY_KEY <> ? AND ENTITY_ID = ?", new Object[]{"CWD_" + userName, entityName, "confluence.user.deactivated", entityId});
                }
                catch (DataAccessException e) {
                    log.error("Error migrating user properties for: " + userName + ", " + e.getMessage(), (Throwable)e);
                }
                processedUsers.add(userName);
            }
            if (++userCount % 100 != 0) continue;
            log.info("Processed {} of {} users...", (Object)userCount, (Object)totalUsers);
        }
    }

    private static String toUserName(String entityName) {
        int userNameStartIndex = entityName.indexOf("_") + 1;
        return IdentifierUtils.toLowerCase((String)entityName.substring(userNameStartIndex));
    }

    private static List<PropertyEntryTuple> getEntityIdsAndNamesOrderedByDate(JdbcTemplate jdbcTemplate) {
        String queryForProperties = "select max(DATE_VAL), ENTITY_NAME, ENTITY_ID from OS_PROPERTYENTRY where ENTITY_NAME like 'LOC_%' or ENTITY_NAME like 'EXT_%' or ENTITY_NAME like 'com.atlassian.user.impl.ldap.DefaultLDAPUser_%' group by ENTITY_NAME, ENTITY_ID order by max(DATE_VAL) desc";
        ArrayList<PropertyEntryTuple> results = new ArrayList<PropertyEntryTuple>();
        jdbcTemplate.query(queryForProperties, rs -> results.add(new PropertyEntryTuple(rs.getLong("ENTITY_ID"), rs.getString("ENTITY_NAME"))));
        return results;
    }

    public void migrateGroupMemberships(final Directory internalDirectory, Connection connection) {
        Session session = this.sessionFactory.getCurrentSession();
        JdbcTemplate jdbcTemplate = DataAccessUtils.getJdbcTemplate(connection);
        int total = (Integer)jdbcTemplate.queryForObject("select count(*) from LOCAL_MEMBERS", Integer.TYPE);
        log.info("Copying {} group memberships...", (Object)total);
        String sql = "select USERS.NAME, GROUPS.GROUPNAME from USERS, GROUPS, LOCAL_MEMBERS where USERS.ID = LOCAL_MEMBERS.USERID and GROUPS.ID = LOCAL_MEMBERS.GROUPID";
        jdbcTemplate.query("select USERS.NAME, GROUPS.GROUPNAME from USERS, GROUPS, LOCAL_MEMBERS where USERS.ID = LOCAL_MEMBERS.USERID and GROUPS.ID = LOCAL_MEMBERS.GROUPID", (RowCallbackHandler)new SessionClearingRowCallbackHandler(session, 100, total){

            @Override
            public void processRowInternal(ResultSet rs) throws SQLException {
                String user = rs.getString(1);
                String group = rs.getString(2);
                try {
                    AtlassianUserDataMigrator.this.membershipDao.addUserToGroup(internalDirectory.getId().longValue(), user, group);
                    log.debug("Copying local membership for user {} to group {}", (Object)user, (Object)group);
                }
                catch (UserNotFoundException e) {
                    log.warn("Membership for non-existent user will not be copied. User name: [{}], group name: [{}]", (Object)user, (Object)group);
                }
                catch (GroupNotFoundException e) {
                    log.warn("Membership for non-existent group will not be copied. User name: [{}], group name: [{}]", (Object)user, (Object)group);
                }
                catch (MembershipAlreadyExistsException e) {
                    log.warn("User [{}] already member of [{}] skipping.", (Object)user, (Object)group);
                }
            }
        });
    }

    public void migrateUsers(final Directory internalDirectory, Connection connection) {
        Session session = this.sessionFactory.getCurrentSession();
        JdbcTemplate jdbcTemplate = DataAccessUtils.getJdbcTemplate(connection);
        int total = (Integer)jdbcTemplate.queryForObject("select count(NAME) from USERS", Integer.TYPE);
        log.info("Copying {} users...", (Object)total);
        String query = this.getQuery(connection);
        jdbcTemplate.query(query, (RowCallbackHandler)new SessionClearingRowCallbackHandler(session, 100, total){

            @Override
            protected void processRowInternal(ResultSet rs) throws SQLException {
                String username = rs.getString(1);
                String password = rs.getString(2);
                String email = rs.getString(3);
                String fullName = rs.getString(4);
                boolean isEnabled = rs.getBoolean(5);
                if (StringUtils.isBlank((CharSequence)username)) {
                    log.warn("User found with blank user name will not be copied. Full name: [{}], email: [{}]", (Object)fullName, (Object)email);
                    return;
                }
                UserTemplate userWithoutNames = new UserTemplate(username, internalDirectory.getId().longValue());
                userWithoutNames.setActive(isEnabled);
                userWithoutNames.setEmailAddress(email);
                userWithoutNames.setDisplayName(StringUtils.defaultString((String)fullName, (String)AtlassianUserDataMigrator.DEFAULT_BLANK));
                com.atlassian.crowd.model.user.User userWithNames = UserUtils.populateNames((com.atlassian.crowd.model.user.User)userWithoutNames);
                log.debug("Copying user: {}", (Object)userWithoutNames.getName());
                try {
                    AtlassianUserDataMigrator.this.userDao.add(userWithNames, PasswordCredential.encrypted((String)StringUtils.defaultString((String)password)));
                }
                catch (UserAlreadyExistsException e) {
                    log.warn("Duplicate entries found for user name '" + username + "', which probably means there were two user names which only differed by case. The first entry found was used '" + e.getUserName() + "', so this user's password and details may not be correct.");
                }
                catch (DirectoryNotFoundException e) {
                    throw new RuntimeException("Internal directory was not created properly.", e);
                }
            }
        });
    }

    private String getQuery(Connection connection) {
        try {
            boolean isColumnPresent = this.dbmsBean.isColumnPresent(connection, "USERS", "ENABLED");
            return isColumnPresent ? "select NAME, PASSWORD, EMAIL, FULLNAME, ENABLED from USERS" : "select NAME, PASSWORD, EMAIL, FULLNAME, true from USERS";
        }
        catch (SQLException e) {
            throw BambooThrowables.propagate((Throwable)e);
        }
    }

    public void migrateGroups(final Directory internalDirectory, Connection connection) {
        Session session = this.sessionFactory.getCurrentSession();
        JdbcTemplate jdbcTemplate = DataAccessUtils.getJdbcTemplate(connection);
        int total = (Integer)jdbcTemplate.queryForObject("select count(GROUPNAME) from GROUPS", Integer.TYPE);
        log.info("Copying {} groups...", (Object)total);
        jdbcTemplate.query("select GROUPNAME from GROUPS", (RowCallbackHandler)new SessionClearingRowCallbackHandler(session, 100, total){

            @Override
            public void processRowInternal(ResultSet rs) throws SQLException {
                String groupName = rs.getString(1);
                try {
                    if (this.findByName(groupName) == null) {
                        AtlassianUserDataMigrator.this.groupDao.add((Group)new GroupTemplate(groupName, internalDirectory.getId().longValue(), GroupType.GROUP));
                    } else {
                        log.info("Skipping creation of pre-existing group " + groupName);
                    }
                }
                catch (InvalidGroupException e) {
                    throw new RuntimeException("Unable to add group '" + groupName + "' to directory", e);
                }
                catch (DirectoryNotFoundException e) {
                    throw new RuntimeException("Internal directory was not created properly.", e);
                }
            }

            @Nullable
            private InternalDirectoryGroup findByName(String groupName) {
                try {
                    return AtlassianUserDataMigrator.this.groupDao.findByName(internalDirectory.getId().longValue(), groupName);
                }
                catch (GroupNotFoundException ignored) {
                    return null;
                }
            }
        });
    }

    public void migrateExternalMemberships(Connection connection, @NotNull Directory externalDirectory) {
        Path membershipDataPath = LocalGroupMapper.getMembershipDataPath((BootstrapManager)this.bootstrapManager);
        if (Files.exists(membershipDataPath, new LinkOption[0])) {
            log.info("Upgrading external membership information using data from export file");
            this.migrateExternalMembershipsFromFile(membershipDataPath, externalDirectory);
            BambooPathUtils.deleteQuietly((Path)membershipDataPath);
        } else {
            log.info("Upgrading external membership information using data from the database");
            this.migrateExternalMembershipsFromDatabase(connection, externalDirectory);
        }
    }

    private void migrateExternalMembershipsFromFile(Path membershipDataPath, Directory externalDirectory) {
        try {
            String json = BambooPathUtils.readFileToString((Path)membershipDataPath, (Charset)StandardCharsets.UTF_8);
            Map memberships = (Map)new Gson().fromJson(json, Map.class);
            for (Map.Entry entry : memberships.entrySet()) {
                String group = (String)entry.getKey();
                List members = (List)entry.getValue();
                for (String user : members) {
                    this.migrateMembershipInLocalGroup(externalDirectory, group, user);
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void migrateExternalMembershipsFromDatabase(Connection connection, final @NotNull Directory externalDirectory) {
        Session session = this.sessionFactory.getCurrentSession();
        JdbcTemplate jdbcTemplate = DataAccessUtils.getJdbcTemplate(connection);
        int total = (Integer)jdbcTemplate.queryForObject("select count(*) from EXTERNAL_MEMBERS", Integer.TYPE);
        log.info("Copying {} local memberships of LDAP users...", (Object)total);
        String sql = "select e.NAME, g.GROUPNAME from EXTERNAL_ENTITIES e, EXTERNAL_MEMBERS m, GROUPS g where e.ID = m.EXTENTITYID and m.GROUPID = g.ID";
        jdbcTemplate.query(sql, (RowCallbackHandler)new SessionClearingRowCallbackHandler(session, 100, total){

            @Override
            public void processRowInternal(ResultSet rs) throws SQLException {
                String userName = rs.getString(1);
                String groupName = rs.getString(2);
                AtlassianUserDataMigrator.this.migrateMembershipInLocalGroup(externalDirectory, groupName, userName);
            }
        });
    }

    private void migrateMembershipInLocalGroup(@Nullable Directory externalDirectory, String groupName, String userName) {
        User user = this.crowdService.getUser(userName);
        if (user == null && (user = this.tryToCreateUser(userName, groupName, externalDirectory)) == null) {
            return;
        }
        if (externalDirectory != null) {
            Group group;
            if (!this.localGroups.containsKey(groupName)) {
                GroupTemplate localGroup = new GroupTemplate(groupName, externalDirectory.getId().longValue(), GroupType.GROUP);
                localGroup.setLocal(true);
                try {
                    Group group2 = this.directoryManager.addGroup(externalDirectory.getId().longValue(), localGroup);
                    this.localGroups.put(groupName, group2);
                }
                catch (DirectoryNotFoundException | InvalidGroupException | OperationFailedException | DirectoryPermissionException e1) {
                    log.warn(String.format("Membership for group migration failed. User name: [%s], group name: [%s]", userName, groupName), e1);
                }
            }
            if ((group = this.localGroups.get(groupName)) == null) {
                log.warn(String.format("Membership for group migration failed (group not found). User name: [%s], group name: [%s]", userName, groupName));
                return;
            }
            try {
                this.directoryManager.addUserToGroup(externalDirectory.getId().longValue(), userName, groupName);
            }
            catch (Exception e) {
                log.warn(String.format("Membership for group migration failed. User name: [%s], group name: [%s]", userName, groupName), (Throwable)e);
                return;
            }
        }
        log.warn(String.format("Membership for group migration failed (no external directory). User name: [%s], group name: [%s]", userName, groupName));
        return;
    }

    @Nullable
    private User tryToCreateUser(String userName, String groupName, @Nullable Directory externalDirectory) {
        if (externalDirectory == null) {
            log.warn("Membership for non-existent user will not be migrated. User name: [{}], group name: [{}]", (Object)userName, (Object)groupName);
            return null;
        }
        log.warn("User not found in local repository. It might be available at external repository, creating user placeholder to be filled by Crowd on LDAP synchronization. User name: [{}], group name: [{}]", (Object)userName, (Object)groupName);
        try {
            UserTemplateWithAttributes newUser = new UserTemplateWithAttributes(userName, externalDirectory.getId().longValue());
            newUser.setActive(true);
            this.userDao.add((com.atlassian.crowd.model.user.User)newUser, PasswordCredential.NONE);
        }
        catch (DirectoryNotFoundException | UserAlreadyExistsException e) {
            log.error(e.getMessage(), e);
            log.error("Can't create user [{}]. Skip membership migration", (Object)userName);
            return null;
        }
        User user = this.crowdService.getUser(userName);
        if (user == null) {
            log.warn("Couldn't find new user {} in LDAP repository", (Object)userName);
            return null;
        }
        return user;
    }

    private static class LegacyDeactivatedFlagMigrator
    implements RowCallbackHandler {
        private final UserDao userDao;
        private final long directoryId;
        private final String userName;

        public LegacyDeactivatedFlagMigrator(UserDao userDao, long directoryId, String userName) {
            this.userDao = userDao;
            this.directoryId = directoryId;
            this.userName = userName;
        }

        public void processRow(ResultSet rs) throws SQLException {
            boolean isActive = !rs.getBoolean("BOOLEAN_VAL");
            try {
                TimestampedUser user = this.userDao.findByName(this.directoryId, this.userName);
                UserTemplate updatedUser = new UserTemplate((com.atlassian.crowd.model.user.User)user);
                updatedUser.setActive(isActive);
                log.debug("User {} has deactivated flag set to {}", (Object)updatedUser.getName(), (Object)(!updatedUser.isActive() ? 1 : 0));
                this.userDao.update((com.atlassian.crowd.model.user.User)updatedUser);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    private static class PropertyEntryTuple {
        private final String name;
        private final long id;

        private PropertyEntryTuple(long id, String name) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }
    }
}

