/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6;

import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserDataMigrator;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.crowd.directory.GenericLDAP;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.embedded.EmbeddedCrowdBootstrap;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import java.sql.Connection;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class UpgradeTask60602MoveUsersToEmbeddedCrowd
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60602MoveUsersToEmbeddedCrowd.class);
    @Inject
    private CrowdDirectoryService crowdDirectoryService;
    @Inject
    private AutowireCapableBeanFactory autowireCapableBeanFactory;
    @Inject
    private EmbeddedCrowdBootstrap embeddedCrowdBootstrap;
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask60602MoveUsersToEmbeddedCrowd() {
        super("Move users to Embedded Crowd");
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws HibernateException {
        try {
            if (!this.dbmsBean.isTablePresent(connection, "GROUPS") || !this.dbmsBean.isTablePresent(connection, "USERS")) {
                return;
            }
            this.migrateData(connection);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void migrateData(Connection connection) {
        boolean isDataDormant;
        Directory internalDirectory = UpgradeTask60602MoveUsersToEmbeddedCrowd.getInternalDirectory(this.crowdDirectoryService);
        boolean bl = isDataDormant = internalDirectory == null;
        if (internalDirectory == null) {
            log.info((Object)"Migrating dormant data");
            internalDirectory = this.embeddedCrowdBootstrap.createInternalDirectory(true);
        }
        AtlassianUserDataMigrator bean = (AtlassianUserDataMigrator)this.autowireCapableBeanFactory.createBean(AtlassianUserDataMigrator.class, 1, false);
        Stopwatch stopwatch = Stopwatch.createStarted();
        bean.migrateGroups(internalDirectory, connection);
        log.info((Object)("Migration of groups took " + stopwatch));
        stopwatch = Stopwatch.createStarted();
        bean.migrateUsers(internalDirectory, connection);
        log.info((Object)("Migration of users took " + stopwatch));
        Directory ldapDirectory = UpgradeTask60602MoveUsersToEmbeddedCrowd.getLdapDirectory(this.crowdDirectoryService);
        if (ldapDirectory != null) {
            Stopwatch stopwatch2 = Stopwatch.createStarted();
            bean.migrateExternalMemberships(connection, ldapDirectory);
            log.info((Object)("Migration of external memberships took " + stopwatch2));
        }
        stopwatch = Stopwatch.createStarted();
        bean.migrateGroupMemberships(internalDirectory, connection);
        log.info((Object)("Migration of group memberships took " + stopwatch));
        stopwatch = Stopwatch.createStarted();
        bean.migrateUserProperties(internalDirectory, connection);
        log.info((Object)("Migration of user properties took " + stopwatch));
        if (isDataDormant) {
            log.info((Object)"Disabling internal directory");
            ImmutableDirectory.Builder directoryBuilder = ImmutableDirectory.newBuilder((Directory)internalDirectory);
            directoryBuilder.setActive(false);
            this.crowdDirectoryService.updateDirectory(directoryBuilder.toDirectory());
        }
    }

    @Nullable
    public static Directory getInternalDirectory(CrowdDirectoryService crowdDirectoryService) {
        for (Directory directory : crowdDirectoryService.findAllDirectories()) {
            if (!InternalDirectory.class.getCanonicalName().equals(directory.getImplementationClass())) continue;
            return directory;
        }
        return null;
    }

    private static Directory getLdapDirectory(CrowdDirectoryService crowdDirectoryService) {
        for (Directory directory : crowdDirectoryService.findAllDirectories()) {
            if (!MicrosoftActiveDirectory.class.getCanonicalName().equals(directory.getImplementationClass()) && !GenericLDAP.class.getCanonicalName().equals(directory.getImplementationClass())) continue;
            return directory;
        }
        return null;
    }
}

