/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_6;

import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigrationException;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.AtlassianUserMigratorFactory;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.CrowdPropertiesPersister;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.CrowdRepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.HibernateRepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.LdapRepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.RepositoryConfigurationMigrator;
import com.atlassian.bamboo.upgrade.tasks.v6_6.ec.UserConfigurationChecker;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.embedded.EmbeddedCrowdBootstrap;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.google.common.base.Throwables;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class UpgradeTask60601MigrateAtlassianUserConfiguration
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60601MigrateAtlassianUserConfiguration.class);
    @Inject
    private CrowdDirectoryService crowdDirectoryService;
    @Inject
    private LDAPPropertiesHelper ldapPropertiesHelper;
    @Inject
    private ApplicationDAO applicationDao;
    @Inject
    private ApplicationFactory applicationFactory;
    @Inject
    private EmbeddedCrowdBootstrap embeddedCrowdBootstrap;
    @Inject
    private CrowdPropertiesPersister crowdPropertiesPersister;
    @Inject
    private BootstrapManager bootstrapManager;
    @Lazy
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask60601MigrateAtlassianUserConfiguration() {
        super("Migrate Atlassian User configuration to Embedded Crowd");
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws HibernateException {
        log.info((Object)"Creating Embedded Crowd Application...");
        this.embeddedCrowdBootstrap.getOrCreateApplication();
        log.info((Object)"Detecting user directories...");
        boolean noDirectoriesPresent = this.crowdDirectoryService.findAllDirectories().isEmpty();
        AtlassianUserMigrator configurationMigrator = this.createConfigurationMigrator(noDirectoriesPresent);
        try {
            log.info((Object)("Found " + configurationMigrator.getMigratorCount() + " user repositories to migrate."));
            this.errors.addAll(configurationMigrator.validate());
            if (!this.errors.isEmpty()) {
                return;
            }
            List<Pair<Directory, RepositoryConfigurationMigrator>> migratedUnsaved = configurationMigrator.migrateAndTestConnections();
            List<Directory> migratedDirectories = configurationMigrator.persistMigratedConfigurations(migratedUnsaved);
            for (Directory directory : migratedDirectories) {
                Application application = this.applicationFactory.getApplication();
                this.applicationDao.addDirectoryMapping(application.getId().longValue(), directory.getId().longValue(), true, directory.getAllowedOperations().toArray(new OperationType[0]));
            }
            this.addInternalDirectoryIfDoesntExist();
            UserConfigurationChecker.appendDeprecationInfo();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void addInternalDirectoryIfDoesntExist() throws ApplicationNotFoundException, DirectoryNotFoundException {
        boolean containsInternalDirectory = this.crowdDirectoryService.findAllDirectories().stream().map(Directory::getImplementationClass).anyMatch(d -> d.equalsIgnoreCase(InternalDirectory.class.getCanonicalName()));
        if (!containsInternalDirectory) {
            Directory internalDirectory = this.embeddedCrowdBootstrap.createInternalDirectory(false);
            Application application = this.applicationFactory.getApplication();
            this.applicationDao.addDirectoryMapping(application.getId().longValue(), internalDirectory.getId().longValue(), true, internalDirectory.getAllowedOperations().toArray(new OperationType[0]));
        }
    }

    private AtlassianUserMigrator createConfigurationMigrator(boolean shouldCreateInternalDirectory) {
        List<RepositoryConfigurationMigrator> migrators = Arrays.asList(new CrowdRepositoryConfigurationMigrator(this.crowdDirectoryService, this.crowdPropertiesPersister), new LdapRepositoryConfigurationMigrator(this.crowdDirectoryService, this.ldapPropertiesHelper), new HibernateRepositoryConfigurationMigrator(this.crowdDirectoryService, this.embeddedCrowdBootstrap, shouldCreateInternalDirectory));
        AtlassianUserMigratorFactory atlassianUserMigratorFactory = new AtlassianUserMigratorFactory(migrators);
        try {
            List<RepositoryConfiguration> atlassianUserConfiguration = UserConfigurationChecker.getAtlassianUserConfiguration(Paths.get(this.bootstrapManager.getConfigDirectory(), new String[0]));
            return atlassianUserMigratorFactory.getMigrator(atlassianUserConfiguration);
        }
        catch (AtlassianUserMigrationException | ConfigurationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

