/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_5;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

public class UpgradeTask60505RenameUniqueIndexOnNotificationsTable
extends AbstractBootstrapUpgradeTask {
    @Inject
    private DbmsBean dbmsBean;
    private static final String EXPECTED_INDEX_NAME = "NOTIFICATIONS_UNIQUE";
    private static Set<String> EXPECTED_COLUMNS = ImmutableSet.of((Object)"RECIPIENT_TYPE", (Object)"RECIPIENT", (Object)"NOTIFICATION_SET", (Object)"CONDITION_KEY", (Object)"CONDITION_DATA");

    public UpgradeTask60505RenameUniqueIndexOnNotificationsTable() {
        super("Fix the name of unique constraint on NOTIFICATIONS table");
    }

    public void doUpgrade() throws Exception {
        if (!this.dbmsBean.isOracle()) {
            return;
        }
        this.withDatabaseConnection(c -> {
            Collection indices = this.dbmsBean.getIndices(c, "NOTIFICATIONS");
            String nameOfIndexFound = null;
            for (DbmsBean.IndexDefinition index : indices) {
                HashSet columnNames = new HashSet(index.getColumns());
                if (!columnNames.equals(EXPECTED_COLUMNS)) continue;
                nameOfIndexFound = index.getName();
                break;
            }
            if (nameOfIndexFound != null && !EXPECTED_INDEX_NAME.equals(nameOfIndexFound)) {
                JdbcUtils.execute((Connection)c, (String)"ALTER INDEX %s RENAME TO %s", (String[])new String[]{nameOfIndexFound, EXPECTED_INDEX_NAME});
            }
        });
    }
}

