/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_4;

import com.atlassian.bamboo.docker.BambooDockerHelper;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.AdministrationConfigurationUpgrader;
import com.atlassian.bamboo.upgrade.UpgradeManager;
import com.atlassian.bamboo.utils.Comparators;
import java.io.IOException;
import java.util.Comparator;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class UpgradeTask60403InitRssSecuritySettings
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60403InitRssSecuritySettings.class);
    @Inject
    private UpgradeManager upgradeManager;

    public UpgradeTask60403InitRssSecuritySettings() {
        super("Initialize default RSS security settings before 6.4 upgrade");
    }

    public void doUpgrade() throws IOException {
        String updatingFrom;
        AdministrationConfigurationUpgrader administrationConfigurationUpgrader = new AdministrationConfigurationUpgrader(this.bootstrapManager);
        Element configElement = administrationConfigurationUpgrader.getElement("rssSecurityConfiguration");
        if (configElement != null) {
            log.info((Object)"Administration configuration contains RSS security configuration - skipping");
            return;
        }
        Comparator applicationBuildNumberComparator = Comparators.getApplicationBuildNumberComparator();
        if (applicationBuildNumberComparator.compare(updatingFrom = this.upgradeManager.getOldBuildNumber(), "60400") < 0 && applicationBuildNumberComparator.compare(updatingFrom, "60300") > 0) {
            log.info((Object)"Creating default 6.3.0 RSS security settings");
            DefaultElement rssSecurityConfiguration = new DefaultElement("rssSecurityConfiguration");
            administrationConfigurationUpgrader.setOrAdd((Element)rssSecurityConfiguration, "enabled", "true");
            administrationConfigurationUpgrader.setOrAdd((Element)rssSecurityConfiguration, "executeSpecsInDocker", "false");
            administrationConfigurationUpgrader.setOrAdd((Element)rssSecurityConfiguration, "dockerImage", BambooDockerHelper.DEFAULT_RSS_DOCKER_IMAGE);
            administrationConfigurationUpgrader.setOrAdd((Element)rssSecurityConfiguration);
            administrationConfigurationUpgrader.save();
        } else {
            log.info((Object)("Upgrade is from version " + updatingFrom + " which doesn't require creation of default RSS security settings"));
        }
    }
}

