/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_3;

import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl;
import com.atlassian.bamboo.specs.BambooSpecsSourceDao;
import com.atlassian.bamboo.specs.BambooSpecsStateDao;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask60303AddSpecsSource
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60303AddSpecsSource.class);
    private static final String VCS_SPECS_STATE_ID_COLUMN = "VCS_SPECS_STATE_ID";
    private static final String BUILD_TABLE = "BUILD";
    private static final String DEPLOYMENT_PROJECT_TABLE = "DEPLOYMENT_PROJECT";
    private static final String GET_BUILDS_WITH_SPECS_SQL = "select BUILD_ID, VCS_SPECS_STATE_ID from BUILD where VCS_SPECS_STATE_ID is not null";
    private static final String GET_DEPLOYMENTS_WITH_SPECS_SQL = "select DEPLOYMENT_PROJECT_ID, VCS_SPECS_STATE_ID from DEPLOYMENT_PROJECT where VCS_SPECS_STATE_ID is not null";
    private static final String MIGRATE_STATE_TO_SOURCE_FOR_BUILD_SQL = "update BUILD set VCS_SPECS_STATE_ID = null, VCS_SPECS_SOURCE_ID = ? where BUILD_ID = ?";
    private static final String MIGRATE_STATE_TO_SOURCE_FOR_DEPLOYMENTS_SQL = "update DEPLOYMENT_PROJECT set VCS_SPECS_STATE_ID = null, VCS_SPECS_SOURCE_ID = ? where DEPLOYMENT_PROJECT_ID = ?";
    private static final String CLEAR_STATE_FOR_BUILD_SQL = "update BUILD set VCS_SPECS_STATE_ID = null where BUILD_ID = ?";
    private static final String CLEAR_STATE_FOR_DEPLOYMENTS_SQL = "update DEPLOYMENT_PROJECT set VCS_SPECS_STATE_ID = null where DEPLOYMENT_PROJECT_ID = ?";
    private static final String FIND_EXISTING_SPECS_SOURCE_SQL = "select VCS_SPECS_SOURCE_ID from VCS_SPECS_SOURCE where VCS_SPECS_STATE_ID = ?";
    @Autowired
    private DbmsBean dbmsBean;
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private BambooSpecsSourceDao specsSourceDao;
    @Autowired
    private BambooSpecsStateDao specsStateDao;
    @Autowired
    private BambooTransactionHibernateTemplate transactionTemplate;

    public UpgradeTask60303AddSpecsSource() {
        super("Migrating relation Build >- VcsLocationBambooSpecsState to  Build >- VcsBambooSpecsSource >- VcsLocationBambooSpecsState");
    }

    public void doUpgrade() throws Exception {
        this.transactionTemplate.doWork(connection -> {
            if (this.dbmsBean.isColumnPresent(connection, BUILD_TABLE, VCS_SPECS_STATE_ID_COLUMN)) {
                log.info((Object)String.format("Table %s contains column %s. Performing migration for plans.", BUILD_TABLE, VCS_SPECS_STATE_ID_COLUMN));
                this.migratePlans(connection);
                log.info((Object)String.format("Dropping column %s from %s table (if exists).", VCS_SPECS_STATE_ID_COLUMN, BUILD_TABLE));
                this.dbmsBean.dropColumn(connection, BUILD_TABLE, VCS_SPECS_STATE_ID_COLUMN);
            }
            if (this.dbmsBean.isColumnPresent(connection, DEPLOYMENT_PROJECT_TABLE, VCS_SPECS_STATE_ID_COLUMN)) {
                log.info((Object)String.format("Table %s contains column %s. Performing migration for deployments", DEPLOYMENT_PROJECT_TABLE, VCS_SPECS_STATE_ID_COLUMN));
                this.migrateDeployments(connection);
                log.info((Object)String.format("Dropping column %s from %s table (if exists).", VCS_SPECS_STATE_ID_COLUMN, BUILD_TABLE));
                this.dbmsBean.dropColumn(connection, DEPLOYMENT_PROJECT_TABLE, VCS_SPECS_STATE_ID_COLUMN);
            }
        });
    }

    private void migratePlans(Connection connection) throws SQLException {
        this.migrateSpecsState(connection, GET_BUILDS_WITH_SPECS_SQL, MIGRATE_STATE_TO_SOURCE_FOR_BUILD_SQL, CLEAR_STATE_FOR_BUILD_SQL);
    }

    private void migrateDeployments(Connection connection) throws SQLException {
        this.migrateSpecsState(connection, GET_DEPLOYMENTS_WITH_SPECS_SQL, MIGRATE_STATE_TO_SOURCE_FOR_DEPLOYMENTS_SQL, CLEAR_STATE_FOR_DEPLOYMENTS_SQL);
    }

    private void migrateSpecsState(Connection connection, String selectEntitiesWithSpecsStateQuery, String migrateStateToSourceQuery, String clearStateForQuery) throws SQLException {
        try (PreparedStatement entititesWithSpecsStateStatement = connection.prepareStatement(selectEntitiesWithSpecsStateQuery);){
            long index = 0L;
            try (ResultSet entitiesWithSpecsStateResultSet = entititesWithSpecsStateStatement.executeQuery();){
                while (entitiesWithSpecsStateResultSet.next()) {
                    ++index;
                    long entityId = entitiesWithSpecsStateResultSet.getLong(1);
                    long specsStateId = entitiesWithSpecsStateResultSet.getLong(2);
                    Optional<VcsBambooSpecsSourceImpl> maybeSpecsSource = this.specsStateDao.findById(specsStateId).map(VcsLocationBambooSpecsStateImpl.class::cast).map(VcsBambooSpecsSourceImpl::javaSpecsSource);
                    if (maybeSpecsSource.isPresent()) {
                        long specsSourceId = this.getOrCreateSpecsSource(connection, maybeSpecsSource.get());
                        try (PreparedStatement unlinkSpecsStateBuildStatement = connection.prepareStatement(migrateStateToSourceQuery);){
                            unlinkSpecsStateBuildStatement.setLong(1, specsSourceId);
                            unlinkSpecsStateBuildStatement.setLong(2, entityId);
                            unlinkSpecsStateBuildStatement.executeUpdate();
                        }
                    }
                    log.warn((Object)String.format("Entity with id %s references not existing VcsLocationBambooSpecsState(%s). Ignoring migration for this entity.", entityId, specsStateId));
                    try (PreparedStatement unlinkSpecsStateBuildStatement = connection.prepareStatement(clearStateForQuery);){
                        unlinkSpecsStateBuildStatement.setLong(1, entityId);
                        unlinkSpecsStateBuildStatement.executeUpdate();
                    }
                    if (index % 500L != 0L) continue;
                    log.debug((Object)"Processed 500 entries. Committing changes.");
                    connection.commit();
                }
            }
        }
    }

    private long getOrCreateSpecsSource(Connection connection, VcsBambooSpecsSourceImpl specsSource) throws SQLException {
        Optional<Long> maybeSpecsSourceId = this.getSpecsSourceId(connection, specsSource.getVcsLocationBambooSpecsState().getId());
        return maybeSpecsSourceId.orElseGet(() -> this.createSpecsSource(specsSource));
    }

    private Optional<Long> getSpecsSourceId(Connection connection, Long specsStateId) throws SQLException {
        try (PreparedStatement findSpecsSourceIdStatement = connection.prepareStatement(FIND_EXISTING_SPECS_SOURCE_SQL);){
            findSpecsSourceIdStatement.setLong(1, specsStateId);
            try (ResultSet resultSet = findSpecsSourceIdStatement.executeQuery();){
                if (resultSet.next()) {
                    long specsSourceId = resultSet.getLong(1);
                    Optional<Long> optional = Optional.of(specsSourceId);
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    private long createSpecsSource(VcsBambooSpecsSourceImpl specsState) {
        this.specsSourceDao.saveOrUpdate((VcsBambooSpecsSource)specsState);
        this.sessionFactory.getCurrentSession().flush();
        return specsState.getId();
    }
}

