/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_3;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.environments.persistence.EnvironmentDao;
import com.atlassian.bamboo.deployments.projects.persistence.DeploymentProjectDao;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.BambooAcegiSecurityUtils;
import com.atlassian.bamboo.security.acegi.acls.AclDao;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.upgrade.utils.DatabaseUpgradePaginator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.Sid;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask60301GrantMissingPermissions
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60301GrantMissingPermissions.class);
    @Autowired
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Autowired
    private AclDao aclDao;
    @Autowired
    private BambooAclUpdateHelper aclUpdateHelper;
    @Autowired
    private DatabaseUpgradePaginator upgradePaginator;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private PlanDao planDao;
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private DeploymentProjectDao deploymentProjectDao;
    @Autowired
    private EnvironmentDao environmentDao;

    public UpgradeTask60301GrantMissingPermissions() {
        super("Grant missing dependent permissions to all principals");
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Upgrading global permissions");
        Multimap<BambooPermission, BambooPermission> globalPermissionDependencies = this.filterRestrictedAdminIfRoleDisabled(Dependencies.GLOBAL_PERMISSION_DEPENDENCIES);
        this.bambooTransactionHibernateTemplate.doWork(connection -> this.doUpgrade(GlobalApplicationSecureObject.INSTANCE, globalPermissionDependencies));
        log.info((Object)String.format("Upgrading permissions of %d plans", this.planDao.countAll(TopLevelPlan.class)));
        this.upgradePaginator.forEach((offset, limit) -> this.planDao.findAllPlans(TopLevelPlan.class, offset, limit), plan -> this.doUpgrade(plan, Dependencies.PLAN_PERMISSION_DEPENDENCIES));
        log.info((Object)String.format("Upgrading permissions of %d projects (also upgrading project-plan permissions)", this.projectDao.count().longValue()));
        this.upgradePaginator.forEach((arg_0, arg_1) -> ((ProjectDao)this.projectDao).findAll(arg_0, arg_1), project -> {
            this.doUpgrade(project, Dependencies.PROJECT_PERMISSION_DEPENDENCIES);
            this.doUpgrade(new ProjectPlanPermissions((ProjectIdentifier)project), Dependencies.PROJECT_PLAN_PERMISSION_DEPENDENCIES);
        });
        log.info((Object)String.format("Upgrading permissions of %d repositories", this.repositoryDefinitionDao.countTopLevelGlobalRepositories()));
        this.upgradePaginator.forEach((arg_0, arg_1) -> ((RepositoryDefinitionDao)this.repositoryDefinitionDao).getTopLevelGlobalRepositories(arg_0, arg_1), repository -> this.doUpgrade(repository, Dependencies.REPOSITORY_PERMISSION_DEPENDENCIES));
        log.info((Object)String.format("Upgrading permissions of %d deployment projects", this.deploymentProjectDao.countAllDeploymentProjects()));
        this.upgradePaginator.forEach((arg_0, arg_1) -> ((DeploymentProjectDao)this.deploymentProjectDao).getAllDeploymentProjects(arg_0, arg_1), deploymentProject -> this.doUpgrade(deploymentProject, Dependencies.DEPLOYMENT_PROJECT_PERMISSION_DEPENDENCIES));
        log.info((Object)String.format("Upgrading permissions of %d environments", this.environmentDao.countAll()));
        this.upgradePaginator.forEach((arg_0, arg_1) -> ((EnvironmentDao)this.environmentDao).findAll(arg_0, arg_1), environment -> this.doUpgrade(environment, Dependencies.ENVIRONMENT_PERMISSION_DEPENDENCIES));
    }

    @VisibleForTesting
    void doUpgrade(@NotNull Object aclEntity, @NotNull Multimap<BambooPermission, BambooPermission> permissionDependencies) {
        HibernateObjectIdentityImpl objectIdentity = new HibernateObjectIdentityImpl(aclEntity);
        Map aclMap = this.aclDao.findAcls((ObjectIdentity)objectIdentity);
        if (aclMap.isEmpty()) {
            log.warn((Object)("ACL for entity not found: " + objectIdentity));
            return;
        }
        MutableAcl acl = (MutableAcl)aclMap.get(objectIdentity);
        ArrayList newPermissionKeys = new ArrayList();
        Map permissionDependenciesMap = permissionDependencies.asMap();
        SetMultimap sidPermissions = MultimapBuilder.treeKeys((Comparator)BambooAcegiSecurityUtils.sidComparator()).hashSetValues().build();
        Arrays.stream(acl.getEntries()).forEach(arg_0 -> UpgradeTask60301GrantMissingPermissions.lambda$doUpgrade$7((Multimap)sidPermissions, arg_0));
        sidPermissions.asMap().forEach((sid, currentPermissions) -> {
            List<BambooPermission> correctedPermissions = currentPermissions.stream().flatMap(permission -> Stream.concat(Stream.of(permission), ((Collection)permissionDependenciesMap.getOrDefault(permission, Collections.emptyList())).stream())).distinct().collect(Collectors.toList());
            correctedPermissions.forEach(permission -> newPermissionKeys.add(BambooAclUpdateHelper.createPermissionKey((Sid)sid, (String)permission.getName())));
        });
        if (newPermissionKeys.size() > sidPermissions.size()) {
            this.aclUpdateHelper.modifyAclAces(acl, newPermissionKeys);
            this.aclDao.save((Acl)acl);
        }
    }

    @NotNull
    private static Multimap<BambooPermission, BambooPermission> calculateEffectiveDependencies(@NotNull Multimap<BambooPermission, BambooPermission> permissionDependencies) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        permissionDependencies.keySet().forEach(permission -> builder.putAll(permission, UpgradeTask60301GrantMissingPermissions.calculateEffectiveDependencies(permissionDependencies, permission)));
        return builder.build();
    }

    @NotNull
    private static Collection<BambooPermission> calculateEffectiveDependencies(@NotNull Multimap<BambooPermission, BambooPermission> permissionDependencies, @NotNull BambooPermission permission) {
        return ((Collection)permissionDependencies.asMap().getOrDefault(permission, Collections.emptyList())).stream().flatMap(dependency -> Stream.concat(Stream.of(dependency), UpgradeTask60301GrantMissingPermissions.calculateEffectiveDependencies(permissionDependencies, dependency).stream())).collect(Collectors.toSet());
    }

    @NotNull
    private Multimap<BambooPermission, BambooPermission> filterRestrictedAdminIfRoleDisabled(@NotNull Multimap<BambooPermission, BambooPermission> permissionDependencies) {
        if (this.administrationConfigurationAccessor.getAdministrationConfiguration().isEnableRestrictedAdmin()) {
            return permissionDependencies;
        }
        return Multimaps.filterEntries(permissionDependencies, entry -> entry != null && !Objects.equals(entry.getKey(), BambooPermission.RESTRICTEDADMINISTRATION) && !Objects.equals(entry.getValue(), BambooPermission.RESTRICTEDADMINISTRATION));
    }

    private static /* synthetic */ void lambda$doUpgrade$7(Multimap sidPermissions, AccessControlEntry ace) {
        sidPermissions.put((Object)ace.getSid(), (Object)((BambooPermission)ace.getPermission()));
    }

    static /* synthetic */ Multimap access$000(Multimap x0) {
        return UpgradeTask60301GrantMissingPermissions.calculateEffectiveDependencies((Multimap<BambooPermission, BambooPermission>)x0);
    }

    private static interface Dependencies {
        public static final Multimap<BambooPermission, BambooPermission> GLOBAL_PERMISSION_DEPENDENCIES = UpgradeTask60301GrantMissingPermissions.access$000((Multimap)ImmutableMultimap.builder().put((Object)BambooPermission.SOX_COMPLIANCE, (Object)BambooPermission.READ).put((Object)BambooPermission.CREATE, (Object)BambooPermission.READ).put((Object)BambooPermission.CREATE_REPOSITORY, (Object)BambooPermission.READ).put((Object)BambooPermission.RESTRICTEDADMINISTRATION, (Object)BambooPermission.CREATE).put((Object)BambooPermission.RESTRICTEDADMINISTRATION, (Object)BambooPermission.CREATE_REPOSITORY).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.RESTRICTEDADMINISTRATION).build());
        public static final Multimap<BambooPermission, BambooPermission> PLAN_PERMISSION_DEPENDENCIES = UpgradeTask60301GrantMissingPermissions.access$000((Multimap)ImmutableMultimap.builder().put((Object)BambooPermission.WRITE, (Object)BambooPermission.READ).put((Object)BambooPermission.BUILD, (Object)BambooPermission.READ).put((Object)BambooPermission.CLONE, (Object)BambooPermission.READ).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.WRITE).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.BUILD).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.CLONE).build());
        public static final Multimap<BambooPermission, BambooPermission> PROJECT_PERMISSION_DEPENDENCIES = UpgradeTask60301GrantMissingPermissions.access$000((Multimap)ImmutableMultimap.builder().put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.CREATE).build());
        public static final Multimap<BambooPermission, BambooPermission> PROJECT_PLAN_PERMISSION_DEPENDENCIES = PLAN_PERMISSION_DEPENDENCIES;
        public static final Multimap<BambooPermission, BambooPermission> REPOSITORY_PERMISSION_DEPENDENCIES = UpgradeTask60301GrantMissingPermissions.access$000((Multimap)ImmutableMultimap.builder().put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.READ).build());
        public static final Multimap<BambooPermission, BambooPermission> DEPLOYMENT_PROJECT_PERMISSION_DEPENDENCIES = UpgradeTask60301GrantMissingPermissions.access$000((Multimap)ImmutableMultimap.builder().put((Object)BambooPermission.WRITE, (Object)BambooPermission.READ).build());
        public static final Multimap<BambooPermission, BambooPermission> ENVIRONMENT_PERMISSION_DEPENDENCIES = UpgradeTask60301GrantMissingPermissions.access$000((Multimap)ImmutableMultimap.builder().put((Object)BambooPermission.WRITE, (Object)BambooPermission.READ).put((Object)BambooPermission.BUILD, (Object)BambooPermission.READ).build());
    }
}

