/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_2;

import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Inject;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class UpgradeTask60203DropExplicitForeignKeyIndices
extends AbstractInHibernateTransactionUpgradeTask {
    @Lazy
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask60203DropExplicitForeignKeyIndices() {
        super("Drop explicit foreign key indices");
    }

    @Override
    public void doUpgrade(@NotNull Connection c) throws HibernateException, SQLException {
        if (this.dbmsBean.isMySql() || this.dbmsBean.isH2()) {
            return;
        }
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_COMMIT", "DEP_VER_COMMIT_AUTHOR_ID");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_COMMIT", "DEP_VER_COMMIT_CHANGESET_ID");
        this.dbmsBean.dropIndexIfExists(c, "PLAN_DEPENDENCIES", "PLAN_DEPENDENCY_CHILD_ID");
        this.dbmsBean.dropIndexIfExists(c, "PLAN_DEPENDENCIES", "PLAN_DEPENDENCY_PARENT_ID");
        this.dbmsBean.dropIndexIfExists(c, "PLAN_VCS_LOCATION", "PLAN_VCS_LOCATION_REPO_ID");
        this.dbmsBean.dropIndexIfExists(c, "PLAN_VCS_LOCATION", "PLAN_VCS_LOCATION_PLAN_ID");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_ENV_VCS_LOCATION", "ENV_VCS_LOCATION_REPO_ID");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_ENV_VCS_LOCATION", "ENV_VCS_LOCATION_ENV_ID");
        this.dbmsBean.dropIndexIfExists(c, "VARIABLE_BASELINE_ITEM", "VAR_ITEM_BASELINE_IDX");
        this.dbmsBean.dropIndexIfExists(c, "CAPABILITY", "CAPABILITY_SET_INDEX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_PROJECT_ITEM", "DEP_PR_ITEM_DEP_ID");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_JIRA_ISSUE", "DEP_VER_JIRAISSUES_VERID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "VCS_LOCATION", "VCS_LOC_PARENT_ID");
        this.dbmsBean.dropIndexIfExists(c, "RELEVANT_CHANGESETS", "REL_CH_BRS_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION", "DV_CTX_BASELINE_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION", "DVERSION_DEP_ID");
        this.dbmsBean.dropIndexIfExists(c, "VARIABLE_CONTEXT", "VAR_CONTEXT_RESULT_IDX");
        this.dbmsBean.dropIndexIfExists(c, "TEST_CLASS_RESULT", "TESTCLASSRES_BUILDRESSUMID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "TEST_CLASS_RESULT", "TESTCLASSRES_TESTCLASSID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "TEST_CASE_RESULT", "TESTCASERES_CLASSRESULTID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "TEST_CASE_RESULT", "TESTCASERES_CASEID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "TEST_CLASS", "TESTCLASS_PLANID_INX");
        this.dbmsBean.dropIndexIfExists(c, "ACL_OBJECT_IDENTITY", "PARENT_OBJECT_IDX");
        this.dbmsBean.dropIndexIfExists(c, "ARTIFACT_DEFINITION", "ART_DEF_PRODUCER_IDX");
        this.dbmsBean.dropIndexIfExists(c, "PLAN_BRANCH_PULL_REQUEST", "PLAN_BRANCH_PR_BRANCH_IDX");
        this.dbmsBean.dropIndexIfExists(c, "PLAN_BRANCH_PULL_REQUEST", "PLAN_BRANCH_PR_PR_IDX");
        this.dbmsBean.dropIndexIfExists(c, "BUILDRESULTSUMMARY", "BRS_STAGE_RESULT_ID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "BUILDRESULTSUMMARY", "RS_CTX_BASELINE_IDX");
        this.dbmsBean.dropIndexIfExists(c, "BUILDRESULTSUMMARY", "BRS_CHAIN_RESULT_SUMMARY_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_ITEM_BA", "VER_LINK_ARTIFACT_ID");
        this.dbmsBean.dropIndexIfExists(c, "BRANCH_COMMIT_INFO", "BRANCH_CREATING_AUTHORID");
        this.dbmsBean.dropIndexIfExists(c, "BRANCH_COMMIT_INFO", "BRANCH_LAST_COMMIT_AUTHORID");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_RESULT", "DR_DEP_VER_ID");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_RESULT", "DR_CTX_BASELINE_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_RESULT", "DR_ENVIRONMENT_ID");
        this.dbmsBean.dropIndexIfExists(c, "CHAIN_STAGE_RESULT", "CSR_CHAIN_RESULT_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_CHANGESET", "DEP_VER_VCS_CHNGSET_VCSLOC_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_CHANGESET", "DEP_VER_VCS_CHANGESET_IDX");
        this.dbmsBean.dropIndexIfExists(c, "REPOSITORY_CHANGESET", "REPOCOMMITS_VCSLOC_IDX");
        this.dbmsBean.dropIndexIfExists(c, "REPOSITORY_CHANGESET", "REPOCOMMITS_BRS_IDX");
        this.dbmsBean.dropIndexIfExists(c, "BUILDRESULTSUMMARY_CUSTOMDATA", "BRS_CUSTOMDATA_BRSID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "BRS_CONSUMED_SUBSCRIPTION", "ARTIFACTLINKID");
        this.dbmsBean.dropIndexIfExists(c, "BRS_CONSUMED_SUBSCRIPTION", "CONSUMERRESULTSUMMARYID");
        this.dbmsBean.dropIndexIfExists(c, "ARTIFACT_SUBSCRIPTION", "ART_SUB_CONSUMER_JOB_IDX");
        this.dbmsBean.dropIndexIfExists(c, "ARTIFACT_SUBSCRIPTION", "ART_SUB_DEFINITION_IDX");
        this.dbmsBean.dropIndexIfExists(c, "VARIABLE_SUBSTITUTION", "VAR_SUBST_RESULT_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_PROJECT_ITEM_BA", "PKG_ITEM_ART_DEF_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEP_VERSION_PLANRESULTKEYS", "DVER_PK_VERSION_ID");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_ITEM", "DVER_ITEM_DVERSION");
        this.dbmsBean.dropIndexIfExists(c, "VARIABLE_DEFINITION", "VAR_DEF_PLAN_IDX");
        this.dbmsBean.dropIndexIfExists(c, "USER_COMMIT", "COMMIT_REPOSITORYCHANGESETID");
        this.dbmsBean.dropIndexIfExists(c, "USER_COMMIT", "COMMIT_AUTHORID");
        this.dbmsBean.dropIndexIfExists(c, "TEST_CASE", "TESTCASE_TESTCLASSID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_ENVIRONMENT", "ENV_DEP_PROJECT_ID");
        this.dbmsBean.dropIndexIfExists(c, "BRS_LINKEDJIRAISSUES", "BRS_LINKEDJIRAISSUES_BRS_IDX");
        this.dbmsBean.dropIndexIfExists(c, "STAGE_VARIABLE_CONTEXT", "STG_VAR_CTX_RESULT_IDX");
        this.dbmsBean.dropIndexIfExists(c, "BUILDRESULTSUMMARY_LABEL", "LABEL_BRSID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "COMMIT_FILES", "COMMIT_FILES_COMMIT_IDX");
        this.dbmsBean.dropIndexIfExists(c, "TEST_ERROR", "TESTERROR_CASERESULTID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "REQUIREMENT", "REQUIREMENT_SET_INDEX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_STATUS", "VERSION_ID_IDX");
        this.dbmsBean.dropIndexIfExists(c, "DEPLOYMENT_VERSION_NAMING", "VER_NAME_DEP_PROJ_IDX");
        this.dbmsBean.dropIndexIfExists(c, "BRS_ARTIFACT_LINK", "PRODUCERJOBRESULTID");
        this.dbmsBean.dropIndexIfExists(c, "BRS_ARTIFACT_LINK", "BUILDRESULTSUMMARYID");
        this.dbmsBean.dropIndexIfExists(c, "BRS_ARTIFACT_LINK", "ART_LINK_ARTIFACT_ID");
    }
}

