/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_2;

import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.security.acegi.acls.AclDao;
import com.atlassian.bamboo.security.acegi.acls.AlwaysGrantAclAuthorizationStrategy;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.v6_6.UpgradeTask60602MoveUsersToEmbeddedCrowd;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.LazyReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.domain.AclAuthorizationStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask60201CreateProjectAcls
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60201CreateProjectAcls.class);
    private static final int PAGE_SIZE = 100;
    private static final String BAMBOO_MIGRATION_USER = "bamboo-migration-user-internal";
    @Inject
    private AclDao aclDao;
    @Inject
    protected BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private UserDao crowdUserDao;
    @Inject
    private CrowdDirectoryService crowdDirectoryService;
    private final Supplier<String> randomUser = new LazyReference<String>(){

        protected String create() {
            boolean isCrowdDataMissing = UpgradeTask60201CreateProjectAcls.this.crowdDirectoryService.findAllDirectories().isEmpty();
            if (isCrowdDataMissing) {
                return UpgradeTask60201CreateProjectAcls.BAMBOO_MIGRATION_USER;
            }
            Directory internalDirectory = UpgradeTask60602MoveUsersToEmbeddedCrowd.getInternalDirectory(UpgradeTask60201CreateProjectAcls.this.crowdDirectoryService);
            if (internalDirectory == null) {
                return UpgradeTask60201CreateProjectAcls.BAMBOO_MIGRATION_USER;
            }
            List user = UpgradeTask60201CreateProjectAcls.this.crowdUserDao.search(internalDirectory.getId().longValue(), QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(1));
            return ((User)Iterables.getOnlyElement((Iterable)user)).getName();
        }
    };

    public UpgradeTask60201CreateProjectAcls() {
        super("Create ACL entries for projects");
    }

    public void doUpgrade() throws Exception {
        int numberOfProjects = this.projectDao.count().intValue();
        log.info((Object)String.format("Found %d projects in total", numberOfProjects));
        AtomicInteger aclsCreatedInTotal = new AtomicInteger(0);
        for (int i = 0; i < numberOfProjects; i += 100) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                for (Project project : this.projectDao.findAll(firstResult, 100)) {
                    int aclsCreatedForProject = this.doUpgrade(project);
                    aclsCreatedInTotal.addAndGet(aclsCreatedForProject);
                }
            });
        }
        log.info((Object)String.format("Created %d ACL entries in total", aclsCreatedInTotal.get()));
    }

    private int doUpgrade(@NotNull Project project) {
        int aclsCreatedForProject = 0;
        HibernateObjectIdentityImpl projectIdentity = new HibernateObjectIdentityImpl((Object)project);
        if (!this.hasAcl((ObjectIdentity)projectIdentity)) {
            log.debug((Object)("Creating ACL entry for project: " + project.getName()));
            this.createAcl((ObjectIdentity)projectIdentity);
            ++aclsCreatedForProject;
        } else {
            log.debug((Object)("ACL entry already exists for project: " + project.getName()));
        }
        HibernateObjectIdentityImpl planPermissionsIdentity = new HibernateObjectIdentityImpl((Object)new ProjectPlanPermissions((ProjectIdentifier)project));
        if (!this.hasAcl((ObjectIdentity)planPermissionsIdentity)) {
            log.debug((Object)("Creating ACL entry for plan permissions for project: " + project.getName()));
            this.createAcl((ObjectIdentity)planPermissionsIdentity);
            ++aclsCreatedForProject;
        } else {
            log.debug((Object)("ACL entry already exists for plan permissions for project: " + project.getName()));
        }
        return aclsCreatedForProject;
    }

    private boolean hasAcl(@NotNull ObjectIdentity objectIdentity) {
        Map existingAcls = this.aclDao.findAcls(objectIdentity);
        return existingAcls != null && existingAcls.containsKey(objectIdentity);
    }

    private void createAcl(@NotNull ObjectIdentity objectIdentity) {
        String user = (String)Preconditions.checkNotNull((Object)this.randomUser.get());
        PrincipalSid sid = new PrincipalSid(user);
        HibernateAclImpl newAcl = new HibernateAclImpl(objectIdentity, null, true, (Sid)sid);
        newAcl.setAclAuthorizationStrategy((AclAuthorizationStrategy)new AlwaysGrantAclAuthorizationStrategy());
        this.aclDao.save((Acl)newAcl);
    }
}

