/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_10;

import com.atlassian.bamboo.setup.BrokerURIUtils;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import java.net.URI;
import org.apache.log4j.Logger;

public class UpgradeTask61009ActiveMQVerifyHostname
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask61009ActiveMQVerifyHostname.class);
    private static final String PROPERTY_TO_REMOVE = "bamboo.jms.broker.client.uri";
    private static final String VERIFY_HOSTNAME_FALSE = "socket.verifyHostName=false";

    public UpgradeTask61009ActiveMQVerifyHostname() {
        super("61009", "Set default socket.verifyHostName=false for SSL Broker Client URI");
    }

    public void doUpgrade() throws Exception {
        URI brokerClientURI = this.bootstrapManager.getBrokerClientURI();
        URI newBrokerUrl = BrokerURIUtils.addParametersToFailoverTransport(brokerClientURI, "ssl", VERIFY_HOSTNAME_FALSE, BrokerURIUtils.MergeMode.PREFER_EXISTING_PARAMETERS);
        this.bootstrapManager.setBrokerClientURI(newBrokerUrl);
    }
}

