/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_10;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask61006EnforceBranchDetectionPolling
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask61006EnforceBranchDetectionPolling.class);
    @Autowired
    private BambooTransactionHibernateTemplate transactionTemplate;
    @Autowired
    private BandanaManager bandanaManager;

    public UpgradeTask61006EnforceBranchDetectionPolling() {
        super("Enforce branch detection to run polling once for each plan");
    }

    public void doUpgrade() throws Exception {
        HashSet affectedPlanIds = new HashSet();
        this.transactionTemplate.doWork(connection -> {
            try (PreparedStatement selectAffectedJobIdsPS = connection.prepareStatement("select distinct CHAIN_ID from VCS_BRANCH");
                 ResultSet rs = selectAffectedJobIdsPS.executeQuery();){
                while (rs.next()) {
                    affectedPlanIds.add(rs.getLong(1));
                }
            }
        });
        for (Long chainId : affectedPlanIds) {
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.forChainId((long)chainId), "enforce.detection.by.polling", (Object)true);
        }
    }
}

