/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_10;

import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.security.acegi.BambooAcegiSecurityUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.util.BambooIterables;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.Sid;
import org.apache.commons.collections4.ListUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask61003GrantProjectViewPermissions
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask61003GrantProjectViewPermissions.class);
    @Inject
    private BambooAclUpdateHelper aclUpdateHelper;
    @Inject
    private HibernateMutableAclService aclService;
    @Inject
    private BambooTransactionHibernateTemplate transactionHibernateTemplate;

    public UpgradeTask61003GrantProjectViewPermissions() {
        super("Grant explicit VIEW permission for projects");
    }

    public void doUpgrade() throws HibernateException {
        ArrayList projectIds = new ArrayList();
        this.transactionHibernateTemplate.doWork(connection -> {
            String query = "select PROJECT_ID from PROJECT where MARKED_FOR_DELETION = ?";
            try (PreparedStatement statement = connection.prepareStatement("select PROJECT_ID from PROJECT where MARKED_FOR_DELETION = ?");){
                statement.setBoolean(1, false);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        projectIds.add(resultSet.getLong(1));
                    }
                }
            }
        });
        for (List projectIdsBatch : ListUtils.partition(projectIds, (int)100)) {
            this.transactionHibernateTemplate.doWork(connection -> {
                Iterator iterator = projectIdsBatch.iterator();
                while (iterator.hasNext()) {
                    long projectId = (Long)iterator.next();
                    MutableAcl acl = this.getOrCreateProjectAcl(projectId);
                    Collection<Sid> sids = this.getRelevantSids(connection, projectId);
                    Set duplicateSids = Arrays.stream(acl.getEntries()).filter(ace -> BambooPermission.READ.equals((Object)ace.getPermission())).map(AccessControlEntry::getSid).collect(Collectors.toCollection(() -> new TreeSet(BambooAcegiSecurityUtils.sidComparator())));
                    for (Sid sid2 : BambooIterables.filter(sids, sid -> !duplicateSids.contains(sid))) {
                        acl.insertAce(null, (Permission)BambooPermission.READ, sid2, true);
                    }
                    this.aclService.updateAcl(acl);
                }
            });
        }
    }

    private MutableAcl getOrCreateProjectAcl(long projectId) throws HibernateException {
        HibernateObjectIdentityImpl objectIdentity = new HibernateObjectIdentityImpl(DefaultProject.class, (Serializable)Long.valueOf(projectId));
        try {
            return this.aclService.readMutableAclById((ObjectIdentity)objectIdentity);
        }
        catch (NotFoundException e) {
            log.info((Object)("ACL not found for project " + projectId + ". It will be created."));
            return this.aclService.createAcl((ObjectIdentity)objectIdentity);
        }
    }

    private Collection<Sid> getRelevantSids(@NotNull Connection connection, long projectId) throws HibernateException, SQLException {
        ArrayList<Sid> result;
        block28: {
            result = new ArrayList<Sid>();
            String query = "select distinct TYPE, SID  from ACL_ENTRY  where ACL_OBJECT_IDENTITY in (      select ID      from ACL_OBJECT_IDENTITY      where OBJECT_ID_CLASS = 'com.atlassian.bamboo.chains.DefaultChain'      and OBJECT_ID_IDENTITY in (          select BUILD_ID          from BUILD          where BUILD_TYPE = 'CHAIN'          and MARKED_FOR_DELETION = ?          and PROJECT_ID = ?      )      or OBJECT_ID_CLASS in (          'com.atlassian.bamboo.project.DefaultProject',          'com.atlassian.bamboo.project.ProjectPlanPermissions'      )      and OBJECT_ID_IDENTITY = ?  )";
            try (PreparedStatement statement = connection.prepareStatement("select distinct TYPE, SID  from ACL_ENTRY  where ACL_OBJECT_IDENTITY in (      select ID      from ACL_OBJECT_IDENTITY      where OBJECT_ID_CLASS = 'com.atlassian.bamboo.chains.DefaultChain'      and OBJECT_ID_IDENTITY in (          select BUILD_ID          from BUILD          where BUILD_TYPE = 'CHAIN'          and MARKED_FOR_DELETION = ?          and PROJECT_ID = ?      )      or OBJECT_ID_CLASS in (          'com.atlassian.bamboo.project.DefaultProject',          'com.atlassian.bamboo.project.ProjectPlanPermissions'      )      and OBJECT_ID_IDENTITY = ?  )");){
                statement.setBoolean(1, false);
                statement.setLong(2, projectId);
                statement.setLong(3, projectId);
                ResultSet resultSet = statement.executeQuery();
                Throwable throwable = null;
                block20: while (true) {
                    try {
                        while (resultSet.next()) {
                            String sidType = resultSet.getString(1);
                            String sidId = resultSet.getString(2);
                            try {
                                result.add(this.aclUpdateHelper.getSidFromIdAndType(sidId, sidType));
                                continue block20;
                            }
                            catch (IllegalArgumentException e) {
                                log.warn((Object)String.format("Could not construct ACL sid (id=%s, type=%s), reason: %s", sidId, sidType, e.getMessage()));
                            }
                        }
                        break block28;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
        }
        return result;
    }
}

