/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_10;

import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;

public class UpgradeTask61002RemoveJobsAndStagesFromChainBranches
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask61002RemoveJobsAndStagesFromChainBranches.class);
    private static String IN_CLAUSE = "in (select BUILD_ID from BUILD where BUILD_TYPE = 'JOB' and MASTER_ID is not null)";
    private static String SET_BUILD_ID_IN_BRS_LABEL_TO_NULL = "update BUILDRESULTSUMMARY_LABEL set BUILD_ID = null where BUILDRESULTSUMMARY_ID is not null and BUILD_ID " + IN_CLAUSE;
    private static String DELETE_LABELS_FOR_BRANCHED_JOBS = "delete from BUILDRESULTSUMMARY_LABEL where BUILDRESULTSUMMARY_ID is null and BUILD_ID " + IN_CLAUSE;
    private static String DELETE_BUILD_DEFINITION = "delete from BUILD_DEFINITION where BUILD_ID " + IN_CLAUSE;
    private static String DELETE_VARIABLES = "delete from VARIABLE_DEFINITION where PLAN_ID " + IN_CLAUSE;
    private static String DELETE_ARTIFACTS = "delete from ARTIFACT_DEFINITION where PRODUCER_JOB_ID " + IN_CLAUSE;
    private static String DELETE_SUBSCRIPTIONS = "delete from ARTIFACT_SUBSCRIPTION where CONSUMER_JOB_ID " + IN_CLAUSE;
    private static String DELETE_AGENT_ASSIGNMENTS = "delete from AGENT_ASSIGNMENT where EXECUTABLE_TYPE = 'JOB' and EXECUTABLE_ID " + IN_CLAUSE;
    private static String DELETE_BRANCHED_JOBS = "delete from BUILD where BUILD_TYPE = 'JOB' and MASTER_ID is not null";
    private static String DELETE_BRANCHED_STAGES = "delete from CHAIN_STAGE where BUILD_ID " + IN_CLAUSE;

    public UpgradeTask61002RemoveJobsAndStagesFromChainBranches() {
        super("Remove jobs and stages from chain branches");
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws HibernateException, SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(SET_BUILD_ID_IN_BRS_LABEL_TO_NULL);
            statement.executeUpdate(DELETE_LABELS_FOR_BRANCHED_JOBS);
            statement.executeUpdate(DELETE_BUILD_DEFINITION);
            statement.executeUpdate(DELETE_VARIABLES);
            statement.executeUpdate(DELETE_ARTIFACTS);
            statement.executeUpdate(DELETE_SUBSCRIPTIONS);
            statement.executeUpdate(DELETE_AGENT_ASSIGNMENTS);
            statement.executeUpdate(DELETE_BRANCHED_JOBS);
            statement.executeUpdate(DELETE_BRANCHED_STAGES);
        }
    }
}

