/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_10;

import com.atlassian.bamboo.upgrade.tasks.v6_9.AbstractMoveJobDataToChainsUpgradeTask;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class UpgradeTask61001AssociateBandanaDataWithChains
extends AbstractMoveJobDataToChainsUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask61001AssociateBandanaDataWithChains.class);
    private static final String selectAffectedJobIds = "select distinct(B.BUILD_ID) FROM BANDANA B join BUILD BLD on B.BUILD_ID = BLD.BUILD_ID where B.BUILD_ID != 0 and B.CHAIN_ID = 0 and BLD.BUILD_TYPE = 'JOB'";
    private static final String updateBandana = "update BANDANA set BUILD_ID = ?, CHAIN_ID = ? where BUILD_ID = ?";
    private static final String copyBuildIdToChainId = "update BANDANA set CHAIN_ID = BUILD_ID where BUILD_ID != 0 and CHAIN_ID = 0";

    public UpgradeTask61001AssociateBandanaDataWithChains() {
        super("Associate bandana data with chains");
    }

    public void doUpgrade() throws Exception {
        this.doUpgrade(selectAffectedJobIds, updateBandana);
        this.transactionTemplate.doWork(connection -> {
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate(copyBuildIdToChainId);
            }
        });
    }
}

