/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_1;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask60103UpdatePlanBranchMonitoringSettings
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60103UpdatePlanBranchMonitoringSettings.class);
    private static int PAGE_SIZE = 100;
    private static final String PLAN_BRANCH_WORKFLOW_MANUAL = "manual";
    private static final String PLAN_BRANCH_WORKFLOW_BRANCHES = "branches";
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private PlanDao planDao;

    public UpgradeTask60103UpdatePlanBranchMonitoringSettings() {
        super("Replace branchCreationEnabled plan configuration setting with workflow setting.");
    }

    public void doUpgrade() throws Exception {
        long numberOfPlans = this.planDao.countAll(TopLevelPlan.class);
        int i = 0;
        while ((long)i < numberOfPlans) {
            int firstResult = i;
            log.debug((Object)("Updating plan " + i + " of " + numberOfPlans));
            this.bambooTransactionHibernateTemplate.doWork(connection -> this.planDao.findAllPlans(TopLevelPlan.class, firstResult, PAGE_SIZE).forEach(this::updatePlan));
            i += PAGE_SIZE;
        }
    }

    private void updatePlan(TopLevelPlan plan) {
        BuildDefinitionForBuild buildDefinitionXml = plan.getBuildDefinitionXml();
        if (buildDefinitionXml == null) {
            return;
        }
        BuildConfiguration buildConfiguration = new BuildConfiguration(buildDefinitionXml.getXmlData());
        if (buildConfiguration.containsKey("branches.branchCreationEnabled")) {
            boolean isBranchCreationEnabled = buildConfiguration.getBoolean("branches.branchCreationEnabled");
            if (buildConfiguration.containsKey("branches.workflow")) {
                String planBranchWorkflow = buildConfiguration.getString("branches.workflow");
                if (!isBranchCreationEnabled && PLAN_BRANCH_WORKFLOW_BRANCHES.equals(planBranchWorkflow)) {
                    buildConfiguration.setProperty("branches.workflow", (Object)PLAN_BRANCH_WORKFLOW_MANUAL);
                }
            } else {
                buildConfiguration.setProperty("branches.workflow", (Object)(isBranchCreationEnabled ? PLAN_BRANCH_WORKFLOW_BRANCHES : PLAN_BRANCH_WORKFLOW_MANUAL));
            }
            buildConfiguration.clearProperty("branches.branchCreationEnabled");
            buildDefinitionXml.setXmlData(buildConfiguration.asXml());
            this.planDao.save((BambooObject)plan);
        } else if (!buildConfiguration.containsKey("branches.workflow")) {
            log.info((Object)String.format("Detected missing properties %s and %s - fixing configuration broken by %s. Setting %s to %s", "branches.branchCreationEnabled", "branches.workflow", "UpgradeTask60102UpdatePlanBranchMonitoringSettings", "branches.workflow", PLAN_BRANCH_WORKFLOW_BRANCHES));
            buildConfiguration.setProperty("branches.workflow", (Object)PLAN_BRANCH_WORKFLOW_BRANCHES);
            buildDefinitionXml.setXmlData(buildConfiguration.asXml());
            this.planDao.save((BambooObject)plan);
        }
    }
}

