/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v6_1;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask60101AddUniqueIndex
extends AbstractBootstrapUpgradeTask {
    public static final String ASSIGNMENT_UNIQUE = "ASSIGNMENT_UNIQUE";
    public static final String AGENT_ASSIGNMENT_TABLE_NAME = "AGENT_ASSIGNMENT";
    public static final String EXECUTOR_ID = "EXECUTOR_ID";
    public static final String EXECUTOR_TYPE = "EXECUTOR_TYPE";
    public static final String EXECUTABLE_TYPE = "EXECUTABLE_TYPE";
    public static final String EXECUTABLE_ID = "EXECUTABLE_ID";
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask60101AddUniqueIndex() {
        super("Create unique index on agent assignment");
    }

    public void doUpgrade() throws Exception {
        AtomicBoolean isConstraintExists = new AtomicBoolean(true);
        this.withDatabaseConnection(c -> {
            if (!this.isConstraintPresent(c, ASSIGNMENT_UNIQUE)) {
                isConstraintExists.set(false);
                this.removeDuplicates(c);
            }
        });
        if (!isConstraintExists.get()) {
            this.withDatabaseConnection(c -> this.dbmsBean.createUniqueConstraint(c, ASSIGNMENT_UNIQUE, AGENT_ASSIGNMENT_TABLE_NAME, new String[]{EXECUTOR_ID, EXECUTOR_TYPE, EXECUTABLE_ID, EXECUTABLE_TYPE}));
        }
    }

    private boolean isConstraintPresent(Connection c, String constraintName) throws SQLException {
        Collection constraints = this.dbmsBean.getConstraints(c, AGENT_ASSIGNMENT_TABLE_NAME, null);
        Predicate<DbmsBean.ConstraintDefinition> isAssignmentUnique = constraint -> constraint.getName().equalsIgnoreCase(constraintName);
        return constraints.stream().anyMatch(isAssignmentUnique);
    }

    void removeDuplicates(@NotNull Connection connection) throws SQLException {
        List<BambooIdProvider> toRemove;
        try (Statement countStmt = connection.createStatement();){
            HashMultimap duplicates = HashMultimap.create();
            try (ResultSet rs = countStmt.executeQuery("select AA.ASSIGNMENT_ID, AA.EXECUTABLE_ID, AA.EXECUTABLE_TYPE, AA.EXECUTOR_ID, AA.EXECUTOR_TYPE\nfrom AGENT_ASSIGNMENT AA\n  join (select EXECUTABLE_ID, EXECUTABLE_TYPE, EXECUTOR_ID, EXECUTOR_TYPE\n        from AGENT_ASSIGNMENT\n        group by EXECUTABLE_ID, EXECUTABLE_TYPE, EXECUTOR_ID, EXECUTOR_TYPE\n        having count(*) > 1) DUP\n    on DUP.EXECUTABLE_ID = AA.EXECUTABLE_ID\n       and DUP.EXECUTABLE_TYPE = AA.EXECUTABLE_TYPE\n       and DUP.EXECUTOR_ID = AA.EXECUTOR_ID\n       and DUP.EXECUTOR_TYPE = AA.EXECUTOR_TYPE");){
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    String key = rs.getLong(2) + "|" + rs.getString(3) + "|" + rs.getLong(4) + "|" + rs.getString(5);
                    duplicates.put((Object)key, (Object)id);
                }
            }
            toRemove = duplicates.asMap().values().stream().flatMap(collection -> collection.stream().skip(1L).map(UpgradeTask60101AddUniqueIndex::toProvider)).collect(Collectors.toList());
        }
        this.removeAllDuplicates(connection, toRemove);
    }

    private void removeAllDuplicates(@NotNull Connection connection, List<BambooIdProvider> toRemove) {
        ListUtils.partition(toRemove, (int)50).forEach(shortList -> {
            try {
                JdbcUtils.runDeleteQuery((Connection)connection, (String)AGENT_ASSIGNMENT_TABLE_NAME, (String)"ASSIGNMENT_ID", (Iterable)shortList);
            }
            catch (SQLException e) {
                Throwables.propagate((Throwable)e);
            }
        });
    }

    private static BambooIdProvider toProvider(Long id) {
        return () -> id;
    }
}

