/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_16;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51605RemoveOldForeignKeysFromRenamedTables
extends AbstractBootstrapUpgradeTask {
    private static final List<Pair<String, String>> FK_TO_BE_REMOVED_AS_TABLES_RENAMED = Arrays.asList(Pair.make((Object)"EXTERNAL_MEMBERS", (Object)"FK_O35Y9WAFG8GXRHFEDX6P840A9"), Pair.make((Object)"EXTERNAL_MEMBERS", (Object)"FK_HBR9I9D2DCT3A205RHH82Y555"), Pair.make((Object)"LOCAL_MEMBERS", (Object)"FK_STJXT95AV33TMIYD4XTF68NHC"), Pair.make((Object)"LOCAL_MEMBERS", (Object)"FK_KBAPW8J5EJXOLEMECF1P86P83"), Pair.make((Object)"VARIABLESTOAUTOINCREMENT", (Object)"FK_I5XELAPGKULQ7LQOVOWE4IRBC"));
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51605RemoveOldForeignKeysFromRenamedTables() {
        super("Remove foreign keys from renamed tables");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(connection -> FK_TO_BE_REMOVED_AS_TABLES_RENAMED.stream().filter(pair -> this.isTablePresent(connection, (String)pair.getFirst())).forEach(pair -> this.dropForeignKeyConstraintIfExists(connection, (String)pair.getFirst(), (String)pair.getSecond())));
    }

    private void dropForeignKeyConstraintIfExists(Connection c, String tableName, String constraintName) {
        try {
            this.dbmsBean.getConstraints(c, tableName, null).stream().filter(constraintDefinition -> constraintDefinition.getName().equalsIgnoreCase(constraintName)).findFirst().ifPresent(this.dropConstraint(c, tableName));
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @NotNull
    private Consumer<DbmsBean.ConstraintDefinition> dropConstraint(Connection c, String tableName) {
        return constraintDefinition -> {
            try {
                this.dbmsBean.dropForeignKeyConstraint(c, tableName, constraintDefinition.getName());
            }
            catch (SQLException e) {
                throw Throwables.propagate((Throwable)e);
            }
        };
    }

    private boolean isTablePresent(Connection connection, String tableName) {
        try {
            return this.dbmsBean.isTablePresent(connection, tableName);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

