/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_16;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51604RemoveExplicitIndexOnUniqueColumns
extends AbstractBootstrapUpgradeTask {
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51604RemoveExplicitIndexOnUniqueColumns() {
        super("Recreate indexes on unique columns");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(this::doUpgrade);
    }

    private void doUpgrade(Connection c) throws SQLException {
        this.dropUniqueConstraints(c, "AUTHOR", "AUTHOR_NAME");
        this.dbmsBean.dropIndexIfExists(c, "AUTHOR", "UK_ffiibfpic09earlrraqgngf1o");
        this.dbmsBean.dropIndexIfExists(c, "AUTHOR", "author_name_idx");
        this.dbmsBean.createUniqueConstraint(c, "UK_ffiibfpic09earlrraqgngf1o", "AUTHOR", new String[]{"AUTHOR_NAME"});
        this.dropUniqueConstraints(c, "BRANCH_COMMIT_INFO", "BRANCH_ID");
        this.dbmsBean.dropIndexIfExists(c, "BRANCH_COMMIT_INFO", "UK_40mo3l9h2lpmkg0vne9q70eh2");
        this.dbmsBean.dropIndexIfExists(c, "BRANCH_COMMIT_INFO", "branch_commit_branch_id_idx");
        this.dbmsBean.createUniqueConstraint(c, "UK_40mo3l9h2lpmkg0vne9q70eh2", "BRANCH_COMMIT_INFO", new String[]{"BRANCH_ID"});
        if (this.dbmsBean.isTablePresent(c, "BUILD_NUMBERS")) {
            this.dropUniqueConstraints(c, "BUILD_NUMBERS", "BUILD_ID");
            this.dbmsBean.dropIndexIfExists(c, "BUILD_NUMBERS", "UK_651b86dhg54bcgvn82tdcw4by");
            this.dbmsBean.dropIndexIfExists(c, "BUILD_NUMBERS", "build_numbers_build_id_idx");
            this.dbmsBean.createUniqueConstraint(c, "UK_651b86dhg54bcgvn82tdcw4by", "BUILD_NUMBERS", new String[]{"BUILD_ID"});
        }
        this.dropUniqueConstraints(c, "BUILD", "FULL_KEY");
        this.dbmsBean.dropIndexIfExists(c, "BUILD", "UK_n3cbpttuc3dd9kx0cao3xobgj");
        this.dbmsBean.dropIndexIfExists(c, "BUILD", "build_key_idx");
        this.dbmsBean.createUniqueConstraint(c, "UK_n3cbpttuc3dd9kx0cao3xobgj", "BUILD", new String[]{"FULL_KEY"});
        this.dropUniqueConstraints(c, "AGENT_AUTHENTICATION", "UUID");
        this.dbmsBean.dropIndexIfExists(c, "AGENT_AUTHENTICATION", "UK_cm59c74kkx7htg87ttqotblh8");
        this.dbmsBean.dropIndexIfExists(c, "AGENT_AUTHENTICATION", "uuid_idx");
        this.dbmsBean.createUniqueConstraint(c, "UK_cm59c74kkx7htg87ttqotblh8", "AGENT_AUTHENTICATION", new String[]{"UUID"});
        this.dropUniqueConstraints(c, "TRUSTED_APPS", "APP_ID");
        this.dbmsBean.dropIndexIfExists(c, "TRUSTED_APPS", "UK_crhbetxf4qgtmwmn72l6mtgdx");
        this.dbmsBean.dropIndexIfExists(c, "TRUSTED_APPS", "trust_apps_app_id_idx");
        this.dbmsBean.createUniqueConstraint(c, "UK_crhbetxf4qgtmwmn72l6mtgdx", "TRUSTED_APPS", new String[]{"APP_ID"});
    }

    private void dropUniqueConstraints(Connection c, String tableName, String columnName) throws SQLException {
        this.dbmsBean.getConstraints(c, tableName, columnName).stream().filter(DbmsBean.ConstraintDefinition::isUniqueKey).forEach(this.dropConstraint(c, tableName));
    }

    private Consumer<DbmsBean.ConstraintDefinition> dropConstraint(Connection c, String tableName) {
        return constraintDefinition -> {
            try {
                this.dbmsBean.dropConstraint(c, tableName, constraintDefinition.getName());
            }
            catch (SQLException e) {
                Throwables.propagate((Throwable)e);
            }
        };
    }
}

