/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_16;

import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.security.MigratingEncryptionService;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.XpathXmlUpgrader;
import com.atlassian.config.util.BootstrapUtils;
import java.io.File;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.w3c.dom.Node;

public class UpgradeTask51602ReEncryptMailPassword
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51602ReEncryptMailPassword.class);
    @Autowired
    @Lazy
    private SecretEncryptionService secretEncryptionService;
    private MigratingEncryptionService migratingEncryptionService;
    private File configFile;

    public UpgradeTask51602ReEncryptMailPassword() {
        super("Re-encrypting SMTP mail server password using new encryption service");
    }

    public void doUpgrade() throws Exception {
        File file = this.getBambooMailConfigFile();
        if (file.isFile()) {
            XpathXmlUpgrader.transform((File)file, (String)"/mail-servers/smtp-server/password", this::reencryptPassword);
        } else {
            log.info((Object)String.format("Mail server configuration file '%s' was not found. Skipping upgrade task.", file.getAbsolutePath()));
        }
    }

    private Node reencryptPassword(Node node) {
        Optional.ofNullable(node.getTextContent()).map(String::trim).map(text -> this.getMigratingEncryptionService().decrypt(text)).ifPresent(decryptedPassword -> node.setTextContent(this.getMigratingEncryptionService().encrypt(decryptedPassword)));
        return node;
    }

    private MigratingEncryptionService getMigratingEncryptionService() {
        if (this.migratingEncryptionService == null) {
            this.migratingEncryptionService = new MigratingEncryptionService(this.secretEncryptionService);
        }
        return this.migratingEncryptionService;
    }

    private File getBambooMailConfigFile() {
        if (this.configFile == null) {
            String applicationHome = BootstrapUtils.getBootstrapManager().getApplicationHome();
            this.configFile = new File(applicationHome, "bamboo-mail.cfg.xml");
        }
        return this.configFile;
    }
}

