/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_16;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51601DropIndexInVariableBaselineItem
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51601DropIndexInVariableBaselineItem.class);
    public static final String TABLE_NAME = "VARIABLE_BASELINE_ITEM";
    public static final String INDEX_NAME = "var_ctx_type_idx";
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51601DropIndexInVariableBaselineItem() {
        super("Delete duplicated index");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(this::doUpgrade);
    }

    public void doUpgrade(Connection connection) throws SQLException {
        if (this.dbmsBean.dropIndexIfExists(connection, TABLE_NAME, INDEX_NAME)) {
            log.info((Object)String.format("Dropping index %s on %s", INDEX_NAME, TABLE_NAME));
        } else {
            log.info((Object)String.format("Skipping task, index %s on %s doesn't exist", INDEX_NAME, TABLE_NAME));
        }
    }
}

